package ru.yandex.direct.intapi.entity.userphone.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

public class CheckVerifiedResponse extends WebSuccessResponse {

    @JsonProperty("uid")
    private Long uid;

    @JsonProperty("verified")
    private boolean verified;

    @JsonProperty("phone")
    private String phone;

    public Long getUid() {
        return uid;
    }

    public boolean getVerified() {
        return verified;
    }

    public String getPhone() {
        return phone;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public CheckVerifiedResponse withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public CheckVerifiedResponse withVerified(boolean verified) {
        this.verified = verified;
        return this;
    }

    public CheckVerifiedResponse withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckVerifiedResponse that = (CheckVerifiedResponse) o;
        return verified == that.verified &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(phone, that.phone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, verified, phone);
    }
}
