package ru.yandex.direct.intapi.entity.vcards;

import java.util.List;

import javax.ws.rs.POST;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.logging.EventType;
import ru.yandex.direct.common.logging.LoggingConfig;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.vcards.model.GetVcardsRequest;
import ru.yandex.direct.intapi.entity.vcards.model.GetVcardsResponse;
import ru.yandex.direct.intapi.entity.vcards.service.VcardsIntapiService;
import ru.yandex.direct.intapi.logging.ClientIdParam;
import ru.yandex.direct.intapi.logging.OperatorUid;
import ru.yandex.direct.intapi.validation.model.IntapiValidationResponse;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;

@RestController
@RequestMapping("vcard")
@AllowServices(production = {DIRECT_WEB_PROD}, testing = {DIRECT_WEB_TEST, DIRECT_DEVELOPER})
public class VcardController {

    private final VcardsIntapiService vcardsIntapiService;


    @Autowired
    public VcardController(VcardsIntapiService vcardsIntapiService) {
        this.vcardsIntapiService = vcardsIntapiService;
    }


    /**
     * @param operatorUid
     * @param clientId
     * @param vcards
     * @return
     */
    @POST
    @ApiOperation(
            value = "валидация визиток",
            nickname = "validate_vcards",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = "validate_vcards",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    @LoggingConfig(logRequestBody = EventType.ALL, logResponseBody = EventType.ALL)
    public IntapiValidationResponse validateVcards(
            @ApiParam(value = "uid оператора", required = true)
            @RequestParam(value = "operator_uid") @OperatorUid long operatorUid,

            @ApiParam(value = "id клиента", required = true)
            @RequestParam(value = "client_id") @ClientIdParam long clientId,

            @ApiParam(value = "Список визиток", required = true)
            @RequestBody() List<Vcard> vcards) {
        return vcardsIntapiService.validateVcards(operatorUid, clientId, vcards);
    }

    /**
     * @param operatorUid
     * @param clientId
     * @param vcards
     * @return
     */
    @POST
    @ApiOperation(
            value = "создание визиток",
            nickname = "create_vcards",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = "create_vcards",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    @LoggingConfig(logRequestBody = EventType.ALL, logResponseBody = EventType.ALL)
    public List<Long> createVcards(
            @ApiParam(value = "uid оператора", required = true)
            @RequestParam(value = "operator_uid") @OperatorUid long operatorUid,

            @ApiParam(value = "id клиента", required = true)
            @RequestParam(value = "client_id") @ClientIdParam long clientId,

            @ApiParam(value = "Список визиток", required = true)
            @RequestBody() List<Vcard> vcards) {
        return vcardsIntapiService.createVcards(operatorUid, clientId, vcards);
    }

    /**
     * @param operatorUid
     * @param clientId
     * @param request
     * @return
     */
    @POST
    @ApiOperation(
            value = "получение визиток",
            nickname = "get_vcards",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = "get_vcards",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    @LoggingConfig(logRequestBody = EventType.ALL, logResponseBody = EventType.ALL)
    public GetVcardsResponse getVcards(
            @ApiParam(value = "uid оператора", required = true)
            @RequestParam(value = "operator_uid") @OperatorUid long operatorUid,

            @ApiParam(value = "id клиента", required = true)
            @RequestParam(value = "client_id") @ClientIdParam long clientId,

            @ApiParam(value = "Список id визиток", required = true)
            @RequestBody() GetVcardsRequest request) {
        return vcardsIntapiService.getVcards(operatorUid, clientId, request);
    }
}
