package ru.yandex.direct.intapi.entity.vcards.presentations;

import ru.yandex.direct.core.entity.vcard.VcardDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.intapi.entity.vcards.service.IntapiVcardDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService.StringLengthDefectIds.CONTACT_EMAIL_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_INVALID_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.StringDefectIds.LOGIN_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_ICQ_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_JABBER_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_MAIL_AGENT_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_SKYPE_OR_MSN_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.LOGIN_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.TYPE_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.UNSUPPORTED_TYPE;
import static ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator.DefectIds.INVALID_METRO;
import static ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator.DefectIds.METRO_CITY_IS_REQUIRED;
import static ru.yandex.direct.core.entity.vcard.service.validation.OgrnConstraint.VoidDefectIds.INVALID_OGRN;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.CityCodeDefectIds.COUNTRY_CODE_MUST_NOT_START_WITH_PLUS;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_LENGTH_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.EXTENSION_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_SHORT;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.CITY_CODE_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.CITY_CODE_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.COUNTRY_CODE_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.COUNTRY_CODE_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.COUNTRY_CODE_MUST_START_WITH_PLUS;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.EXTENSION_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.PHONE_NUMBER_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.PHONE_NUMBER_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.BANNERS_WITH_VCARD_ID_NOT_FOUND;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.INCONSISTENT_VCARD_CID_AND_CAMPAIGN_ID;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.VCARD_HAS_VALIDATION_ERRORS;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.VCARD_IS_DUPLICATED;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.VCARD_IS_IN_USE;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.StringDefectIds.WORKTIME_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_DAYS_DUPLICATED;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_MINUTE_NOT_DIVISIBLE_BY_15;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_TIME_FORMAT_IS_INVALID;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class VcardDefectPresentations {

    private VcardDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> vcardDefectPresentationRegistry() {
        IntapiVcardDefectTranslations intapiTranslations = IntapiVcardDefectTranslations.INSTANCE;
        VcardDefectTranslations coreTranslations = VcardDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(BANNERS_WITH_VCARD_ID_NOT_FOUND, defaultIntapiDefect())
                .register(VCARD_HAS_VALIDATION_ERRORS, defaultIntapiDefect())
                .register(INCONSISTENT_VCARD_CID_AND_CAMPAIGN_ID, defaultIntapiDefect())

                // InstantMessenger
                .register(TYPE_IS_NULL,
                        paramIntapiDefect(di -> intapiTranslations.instantMessengerTypeIsNull(di.getPath())))
                .register(UNSUPPORTED_TYPE,
                        paramIntapiDefect(di -> intapiTranslations.instantMessengerTypeIsUnsupported(di.getPath())))

                .register(LOGIN_IS_NULL,
                        paramIntapiDefect(di -> commonTranslations.absentValueInFieldDetailed(di.getPath())))
                .register(LOGIN_IS_TOO_LONG,
                        paramIntapiDefect(di -> commonTranslations.invalidValueWithOnlyPathDetailed(di.getPath())))

                .register(INVALID_ICQ_LOGIN_FORMAT,
                        paramIntapiDefect(di -> intapiTranslations.invalidIcqLoginFormatWithPath(di.getPath())))
                .register(INVALID_MAIL_AGENT_LOGIN_FORMAT,
                        paramIntapiDefect(di -> intapiTranslations.invalidMailAgentLoginFormatWithPath(di.getPath())))
                .register(INVALID_JABBER_LOGIN_FORMAT,
                        paramIntapiDefect(di -> intapiTranslations.invalidJabberLoginFormatWithPath(di.getPath())))
                .register(INVALID_SKYPE_OR_MSN_LOGIN_FORMAT,
                        paramIntapiDefect(di -> intapiTranslations.invalidSkypeOrMsnLoginFormatWithPath(di.getPath())))
                .register(VCARD_IS_DUPLICATED,
                        intapiDefect(coreTranslations.vcardIsDuplicated()))

                //vcard заглушки
                .register(VCARD_IS_IN_USE, defaultIntapiDefect())

                // Ogrn
                .register(INVALID_OGRN,
                        paramIntapiDefect(di -> commonTranslations.invalidValueWithOnlyPathDetailed(di.getPath())))

                // Phone
                .register(COUNTRY_CODE_IS_NULL,
                        paramIntapiDefect(di -> intapiTranslations.phoneCountryCodeIsNullOrEmptyWithPath(di.getPath())))
                .register(COUNTRY_CODE_IS_EMPTY,
                        paramIntapiDefect(di -> intapiTranslations.phoneCountryCodeIsNullOrEmptyWithPath(di.getPath())))
                .register(COUNTRY_CODE_IS_TOO_LONG,
                        paramIntapiDefect(di -> intapiTranslations.invalidCountryCodeFormatWithPath(di.getPath())))
                .register(COUNTRY_CODE_MUST_START_WITH_PLUS,
                        paramIntapiDefect(di -> intapiTranslations.countryCodeMustStartWithPlusWithPath(di.getPath())))
                .register(COUNTRY_CODE_MUST_NOT_START_WITH_PLUS,
                        paramIntapiDefect(di -> intapiTranslations
                                .countryCodeMustNotStartWithPlusWithPath(
                                        ((String) di.getValue()).substring(1), di.getDefect().params(), di.getPath())))
                .register(COUNTRY_CODE_FORMAT_IS_INVALID,
                        paramIntapiDefect(di -> intapiTranslations.invalidCountryCodeFormatWithPath(di.getPath())))

                .register(CITY_CODE_IS_NULL,
                        paramIntapiDefect(di -> intapiTranslations.phoneCityCodeIsNullOrEmptyWithPath(di.getPath())))
                .register(CITY_CODE_IS_EMPTY,
                        paramIntapiDefect(di -> intapiTranslations.phoneCityCodeIsNullOrEmptyWithPath(di.getPath())))
                .register(CITY_CODE_IS_TOO_LONG,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneCityCodeFormatWithPath(di.getPath())))
                .register(CITY_CODE_FORMAT_IS_INVALID,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneCityCodeFormatWithPath(di.getPath())))

                .register(PHONE_NUMBER_IS_NULL,
                        paramIntapiDefect(di -> intapiTranslations.phoneNumberIsNullOrEmptyWithPath(di.getPath())))
                .register(PHONE_NUMBER_IS_EMPTY,
                        paramIntapiDefect(di -> intapiTranslations.phoneNumberIsNullOrEmptyWithPath(di.getPath())))
                .register(PHONE_NUMBER_IS_TOO_SHORT,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneNumberFormatWithPath(di.getPath())))
                .register(PHONE_NUMBER_IS_TOO_LONG,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneNumberFormatWithPath(di.getPath())))
                .register(PHONE_NUMBER_FORMAT_IS_INVALID,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneNumberFormatWithPath(di.getPath())))

                .register(EXTENSION_IS_TOO_LONG,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneExtensionFormatWithPath(di.getPath())))
                .register(EXTENSION_FORMAT_IS_INVALID,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneExtensionFormatWithPath(di.getPath())))

                .register(ENTIRE_PHONE_LENGTH_IS_INVALID,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneNumberFormatWithPath(di.getPath())))
                .register(ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG,
                        paramIntapiDefect(di -> intapiTranslations.invalidPhoneNumberFormatWithPath(di.getPath())))

                // ContactEmail
                .register(CONTACT_EMAIL_IS_EMPTY,
                        paramIntapiDefect(di -> commonTranslations.absentValueInFieldDetailed(di.getPath())))
                .register(CONTACT_EMAIL_TOO_LONG,
                        paramIntapiDefect(di -> coreTranslations.invalidContactEmailFormat(di.getPath())))
                .register(CONTACT_EMAIL_INVALID_FORMAT,
                        paramIntapiDefect(di -> coreTranslations.invalidContactEmailFormat(di.getPath())))

                // MetroId
                .register(METRO_CITY_IS_REQUIRED,
                        intapiDefect(intapiTranslations.metroCityIsRequiredWithCity(intapiTranslations.cityField())))
                .register(INVALID_METRO,
                        paramIntapiDefect(di -> intapiTranslations.invalidMetroWithPath(di.getPath())))

                // WorkTime
                .register(WORKTIME_IS_EMPTY,
                        paramIntapiDefect(di -> commonTranslations.absentValueInFieldDetailed(di.getPath())))
                .register(WORKTIME_FORMAT_IS_INVALID,
                        paramIntapiDefect(di -> commonTranslations.invalidFormatWithPathDetailed(di.getPath())))
                .register(WORKTIME_TIME_FORMAT_IS_INVALID,
                        paramIntapiDefect(di -> coreTranslations.invalidWorktimeTimeFormat(di.getPath())))
                .register(WORKTIME_MINUTE_NOT_DIVISIBLE_BY_15,
                        paramIntapiDefect(di -> coreTranslations.worktimeMinuteNotDivisibleBy15(di.getPath())))
                .register(WORKTIME_DAYS_DUPLICATED,
                        paramIntapiDefect(di -> coreTranslations.worktimeDaysDuplicated(di.getPath())))
                .register(WORKTIME_IS_TOO_LONG,
                        paramIntapiDefect(di -> commonTranslations.invalidFormatWithPathDetailed(di.getPath())))
                .build();
    }
}
