package ru.yandex.direct.intapi.entity.vcards.service;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.validation.result.Path;

@SuppressWarnings("checkstyle:linelength")
public interface IntapiVcardDefectTranslations extends TranslationBundle {
    IntapiVcardDefectTranslations INSTANCE = I18NBundle.implement(IntapiVcardDefectTranslations.class);

    // Phone.CountryCode
    @MessageFormatStub("Не указан код страны в поле {0}")
    Translatable phoneCountryCodeIsNullOrEmptyWithPath(Path path);

    @MessageFormatStub("Код страны в поле {0} должен начинаться со знака '+'")
    Translatable countryCodeMustStartWithPlusWithPath(Path path);

    @MessageFormatStub("В поле {2} код страны '{0}' вместе с кодом города '{1}' не может начинаться со знака '+'")
    Translatable countryCodeMustNotStartWithPlusWithPath(String countryCode, String cityCode, Path path);

    @MessageFormatStub("Код страны в поле {0} должен содержать от 1 до 5 символов, начинаться со знака '+' или '8' и состоять из цифр")
    Translatable invalidCountryCodeFormatWithPath(Path path);

    // Phone.CityCode
    @MessageFormatStub("Не указан код города в поле {0}")
    Translatable phoneCityCodeIsNullOrEmptyWithPath(Path path);

    @MessageFormatStub("Код города в поле {0} должен содержать от 1 до 5 символов, быть не равным 0 и состоять только из цифр")
    Translatable invalidPhoneCityCodeFormatWithPath(Path path);

    // Phone.Number
    @MessageFormatStub("Не указан номер телефона в поле {0}")
    Translatable phoneNumberIsNullOrEmptyWithPath(Path path);

    @MessageFormatStub("В поле {0} указан неправильный формат номера телефона")
    Translatable invalidPhoneNumberFormatWithPath(Path path);

    // Phone.Extension
    @MessageFormatStub("Добавочный номер в поле {0} должен содержать от 1 до 6 символов и состоять только из цифр")
    Translatable invalidPhoneExtensionFormatWithPath(Path path);

    // MetroId
    @MessageFormatStub("В поле \"{0}\" не указано значение, необходимое для определения станции метро")
    Translatable metroCityIsRequiredWithCity(Translatable cityField);

    @MessageFormatStub("Город")
    Translatable cityField();

    @MessageFormatStub("В поле {0} указана станция, не существующая в выбранном городе")
    Translatable invalidMetroWithPath(Path path);

    // InstantMessenger
    @MessageFormatStub("ICQ UIN в поле {0} должен содержать от 5 до 10 цифр и состоять из цифр и дефисов")
    Translatable invalidIcqLoginFormatWithPath(Path path);

    @MessageFormatStub("Имя почтового ящика для Мail.Ru Агента в поле {0} должно содержать только email-адрес с доменами mail.ru, inbox.ru, bk.ru, list.ru")
    Translatable invalidMailAgentLoginFormatWithPath(Path path);

    @MessageFormatStub("Jabber-идентификатор в поле {0} должен содержать только email-адрес")
    Translatable invalidJabberLoginFormatWithPath(Path path);

    @MessageFormatStub("Skype-имя в поле {0} должно содержать email-адрес или имя, состоящее из букв, цифр и знаков пунктуации")
    Translatable invalidSkypeOrMsnLoginFormatWithPath(Path path);

    @MessageFormatStub("В поле {0} не указан тип интернет-пейджера")
    Translatable instantMessengerTypeIsNull(Path path);

    @MessageFormatStub("В поле {0} указан неподдерживаемый тип интернет-пейджера")
    Translatable instantMessengerTypeIsUnsupported(Path path);
}
