package ru.yandex.direct.intapi.entity.video

import org.springframework.web.multipart.MultipartFile

internal enum class CheckFileResult(val description: String?) {
    OK("") {
        override fun getErrorMessage(file: MultipartFile): String {
            return "OK"
        }
    },
    BAD_FORMAT("Content type of file must be 'video/mp4'") {
        override fun getErrorMessage(file: MultipartFile): String {
            return "Content type of ${file.originalFilename} must be 'video/mp4', but found '${file.contentType}'"
        }
    };

    fun validate(): Boolean {
        return this == OK
    }

    abstract fun getErrorMessage(file: MultipartFile): String
}
