package ru.yandex.direct.intapi.logging;

import javax.servlet.http.HttpServletRequest;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.common.logging.LogRecord;

@SuppressWarnings({"FieldCanBeLocal", "unused", "WeakerAccess"})
public class IntapiLogRecord extends LogRecord {

    private static final String LOG_SERVICE_NAME = "direct.java.intapi";

    @JsonProperty("client_id")
    private Long clientId;

    public IntapiLogRecord(long requestId, HttpServletRequest request) {
        super(requestId, request);
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getService() {
        return LOG_SERVICE_NAME;
    }
}
