package ru.yandex.direct.intapi.logging;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.logging.LogRecordHolder;
import ru.yandex.direct.common.logging.LoggingFilter;
import ru.yandex.direct.common.logging.LoggingSettings;

@Component
@ParametersAreNonnullByDefault
public class IntapiLoggingFilter extends LoggingFilter<IntapiLogRecord> {

    private static final String LOGGER_NAME = "PPCLOG_INTAPI.log";

    @Autowired
    public IntapiLoggingFilter(LoggingSettings loggingDefaults, LogRecordHolder<IntapiLogRecord> logRecordHolder) {
        super(LOGGER_NAME, loggingDefaults, logRecordHolder);
    }

    @Override
    protected void initLogRecord(long requestId, HttpServletRequest requestToUse) {
        logRecordHolder.setLogRecord(new IntapiLogRecord(requestId, requestToUse));
    }
}
