package ru.yandex.direct.intapi.logging;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.logging.LogRecordHolder;
import ru.yandex.direct.common.logging.RequestBodyLogWriter;

@Component
public class RequestParametersLogWriter extends RequestBodyLogWriter<IntapiLogRecord> {

    @Autowired
    public RequestParametersLogWriter(LogRecordHolder<IntapiLogRecord> logRecordHolder) {
        super(logRecordHolder);
    }

    public void writeOperatorUidToLog(Object requestArgument) {
        IntapiLogRecord logRecord = logRecordHolder.getLogRecord();
        //может быть null, например, в тестах, если фильтры отключены, так как logRecord создается в фильтре
        if (logRecord == null || requestArgument == null) {
            return;
        }
        logRecord.setOperatorId(Long.valueOf(requestArgument.toString()));
    }

    public void writeClientIdToLog(Object requestArgument) {
        IntapiLogRecord logRecord = logRecordHolder.getLogRecord();
        //может быть null, например, в тестах, если фильтры отключены, так как logRecord создается в фильтре
        if (logRecord == null || requestArgument == null) {
            return;
        }
        logRecord.setClientId(Long.valueOf(requestArgument.toString()));
    }
}
