package ru.yandex.direct.intapi.validation;

import ru.yandex.direct.core.entity.adgeneration.model.GenerationDefectIds;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds;
import ru.yandex.direct.core.entity.calltrackingsettings.validation.CalltrackingSettingDefects;
import ru.yandex.direct.core.entity.clientphone.validation.ClientPhoneDefects;
import ru.yandex.direct.core.entity.contentpromotion.validation.defects.ContentPromotionDefectIds;
import ru.yandex.direct.core.entity.conversionsource.validation.ConversionSourceDefects;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefectIds;
import ru.yandex.direct.core.entity.feedoffer.validation.FeedOfferDefects;
import ru.yandex.direct.core.entity.hrefparams.validation.defects.HrefParamsDefectIds;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoDefectIds;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdsAccessGroupDefects;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectTranslations;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectIds;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectTranslations;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterDefects;
import ru.yandex.direct.core.entity.promoextension.PromoExtensionNumericDefectIds;
import ru.yandex.direct.core.entity.uac.validation.AppInfoDefectIds;
import ru.yandex.direct.core.entity.uac.validation.ContentDefectIds;
import ru.yandex.direct.core.entity.uac.validation.ParseAppInfoUrlDefectIds;
import ru.yandex.direct.core.entity.uac.validation.TrackingUrlDefectIds;
import ru.yandex.direct.core.entity.userssegments.service.validation.UsersSegmentDefectIds;
import ru.yandex.direct.core.service.integration.balance.defects.BalanceDefectIds;
import ru.yandex.direct.core.service.integration.balance.defects.BalanceNumericDefectIds;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.core.validation.defects.ids.AdDefectIds;
import ru.yandex.direct.core.validation.defects.ids.CurrencyDefectIds;
import ru.yandex.direct.excel.processing.validation.defects.ExcelDefectIds;
import ru.yandex.direct.excel.processing.validation.defects.ExcelDefectIdsWithParams;
import ru.yandex.direct.grid.processing.service.client.validation.ClientMccDefectIds;
import ru.yandex.direct.grid.processing.service.offer.validation.OfferDefectIds;
import ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.defect.ids.DateDefectIds;
import ru.yandex.direct.validation.defect.ids.DateTimeDefectIds;
import ru.yandex.direct.validation.defect.ids.NumberDefectIds;
import ru.yandex.direct.validation.defect.ids.StringDefectIds;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.DefectIds;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class CommonDefectPresentations {

    private CommonDefectPresentations() {
    }

    @SuppressWarnings({"checkstyle:methodlength", "checkstyle:MethodParamPad"})
    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> commonDefectPresentationRegistry() {
        CommonDefectTranslations coreTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()

                //common
                .register(DefectIds.MUST_BE_NULL, defaultIntapiDefect())
                .register(DefectIds.MUST_BE_EMPTY, defaultIntapiDefect())
                .register(DefectIds.MUST_BE_WHOLE_NUMBER, defaultIntapiDefect())
                .register(DefectIds.CANNOT_BE_NULL,
                        paramIntapiDefect(di -> coreTranslations.absentValueInFieldDetailed(di.getPath())))
                .register(DefectIds.CANNOT_BE_EMPTY,
                        paramIntapiDefect(di -> coreTranslations.emptyDetailed(di.getPath())))
                .register(DefectIds.ABSENT_REQUIRED_FIELD,
                        paramIntapiDefect(di -> coreTranslations.absentDetailed(di.getPath())))
                .register(DefectIds.INVALID_VALUE,
                        paramIntapiDefect(di -> coreTranslations.invalidValueDetailed(di.getValue())))
                .register(DefectIds.INVALID_FORMAT,
                        paramIntapiDefect(di -> coreTranslations.invalidFormatWithPathDetailed(di.getPath())))
                .register(DefectIds.MUST_BE_VALID_ID,
                        intapiDefect(coreTranslations.incorrectIdDetailed()))
                .register(DefectIds.MUST_BE_VALID_LOGIN,
                        defaultIntapiDefect())
                .register(DefectIds.LOGIN_CANNOT_BE_PDD,
                        intapiDefect(coreTranslations.loginCannotBePdd()))
                .register(DefectIds.OBJECT_NOT_FOUND,
                        intapiDefect(coreTranslations.notFoundShort()))
                .register(DefectIds.UNABLE_TO_DELETE,
                        intapiDefect(coreTranslations.unableToDeleteShort()))
                .register(DefectIds.FORBIDDEN_TO_CHANGE,
                        intapiDefect(coreTranslations.forbiddenToChangeShort()))
                .register(DefectIds.NO_RIGHTS_CANT_WRITE,
                        intapiDefect(coreTranslations.noRightsCantWrite()))
                .register(DefectIds.INCONSISTENT_STATE,
                        intapiDefect(coreTranslations.inconsistentStateDetailed()))
                .register(DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS,
                        intapiDefect(coreTranslations.alreadyExistsShort()))
                .register(DefectIds.REQUIRED_BUT_EMPTY,
                        paramIntapiDefect(di -> coreTranslations.requiredButEmptyDetailed(di.getPath())))
                .register(DefectIds.NO_RIGHTS,
                        paramIntapiDefect(di -> coreTranslations.noRightsDetailed(di.getPath())))
                .register(DefectIds.MUST_CONTAIN_LETTERS,
                        paramIntapiDefect(di -> coreTranslations.mustContainLettersDetailed(di.getPath())))
                .register(DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS,
                        paramIntapiDefect(di -> coreTranslations
                                .mustContainLettersOrDigitsOrPunctuationsDetailed(di.getPath())))
                .register(DefectIds.CAMPAIGN_STATUS_ARCHIVED,
                        intapiDefect(coreTranslations.badCampaignStatusArchivedCanNotChange()))
                .register(DefectIds.UNKNOWN_PARAMETER, defaultIntapiDefect())
                .register(DefectIds.ONE_OF_HREF_OR_TURBOLANDING_ID_MUST_BE_NOT_NULL,
                        intapiDefect(coreTranslations.oneOfHrefOrTurboLandingIdMustBeNotNull()))
                .register(AdGroupDefectIds.Gen.ERRORS_WHILE_COPYING_ADGROUPS, defaultIntapiDefect())

                .register(DefectIds.METRIKA_RETURNS_RESULT_WITH_ERRORS, defaultIntapiDefect())
                .register(DefectIds.FAILED_TO_ACQUIRE_LOCK, defaultIntapiDefect())

                //string defects
                .register(StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        paramIntapiDefect(di -> coreTranslations.lengthOfFieldValueMustNotExceed(
                                di.getPath(),
                                di.getDefect().params().getMaxLength().toString())
                        ))
                .register(StringDefectIds.LENGTH_CANNOT_BE_LESS_THAN_MIN,
                        defaultIntapiDefect())
                .register(StringDefectIds.LENGTH_MUST_BE_IN_THE_INTERVAL,
                        defaultIntapiDefect())
                .register(StringDefectIds.CANNOT_BE_EMPTY,
                        paramIntapiDefect(di -> coreTranslations.absentValueInFieldDetailed(di.getPath())))
                .register(StringDefectIds.CANNOT_CONTAIN_SYMBOLS,
                        paramIntapiDefect(di -> coreTranslations.invalidCharsDetailed(di.getPath())))
                .register(StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS,
                        intapiDefect(coreTranslations.invalidCharsShort()))
                .register(StringDefectIds.MAX_COUNT_WORDS_IN_KEYWORD,
                        defaultIntapiDefect())
                .register(StringDefectIds.REQUIRED_BUT_EMPTY,
                        paramIntapiDefect(di -> coreTranslations.requiredButEmptyDetailed(di.getPath())))

                //number defects
                .register(NumberDefectIds.MUST_BE_LESS_THEN_MAX, defaultIntapiDefect())
                .register(NumberDefectIds.MUST_BE_GREATER_THAN_MIN, defaultIntapiDefect())
                .register(NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX, defaultIntapiDefect())
                .register(NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN, defaultIntapiDefect())
                .register(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE,
                        paramIntapiDefect(di -> coreTranslations.fieldMustBeInRange(
                                di.getPath(),
                                Identity.of(di.getDefect().params().getMin().intValue()),
                                Identity.of(di.getDefect().params().getMax().intValue())
                        )))
                .register(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS, defaultIntapiDefect())
                .register(NumberDefectIds.MUST_BE_NOT_OLDER, defaultIntapiDefect())

                //dates
                .register(DateDefectIds.MUST_BE_LESS_THAN_MAX, defaultIntapiDefect())
                .register(DateDefectIds.MUST_BE_LESS_THAN_OR_EQUAL_TO_MAX, defaultIntapiDefect())
                .register(DateDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN, defaultIntapiDefect())
                .register(DateDefectIds.MUST_BE_GREATER_THAN_MIN, defaultIntapiDefect())
                .register(DateDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS, defaultIntapiDefect())
                .register(DateDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE, defaultIntapiDefect())
                .register(DateDefectIds.END_DATE_MUST_BE_GREATER_THAN_OR_EQUAL_TO_START_DATE, defaultIntapiDefect())

                // times
                .register(DateTimeDefectIds.MUST_BE_GREATER_THAN_MIN, defaultIntapiDefect())
                .register(DateTimeDefectIds.BROAD_HISTORY_TIME_INTERVAL, defaultIntapiDefect())

                //collections
                .register(CollectionDefectIds.Size.INVALID_COLLECTION_SIZE,
                        paramIntapiDefect(di -> coreTranslations.invalidCollectionSizeDetailed(
                                di.getPath(),
                                new Identity((long) di.getDefect().params().getMinSize()),
                                new Identity((long) di.getDefect().params().getMaxSize())
                        )))
                .register(CollectionDefectIds.Gen.MUST_BE_IN_COLLECTION,
                        paramIntapiDefect(di -> coreTranslations.notFoundDetailed(di.getPath())))
                .register(CollectionDefectIds.Size.MAX_ELEMENTS_PER_REQUEST,
                        paramIntapiDefect(di -> coreTranslations
                                .maxElementsPerRequestDetailed(new Identity(di.getDefect().params().getMaxSize()))))
                .register(CollectionDefectIds.Size.MAX_ELEMENTS_EXCEEDED,
                        paramIntapiDefect(di -> CommonDefectTranslations.INSTANCE
                                .maxElementsExceededDetailed(new Identity(di.getDefect().params().getMaxSize()))))
                .register(CollectionDefectIds.Size.SIZE_MUST_BE_IN_INTERVAL,
                        paramIntapiDefect(di -> coreTranslations.invalidCollectionSizeDetailed(
                                di.getPath(),
                                new Identity(di.getDefect().params().getMinSize()),
                                new Identity(di.getDefect().params().getMaxSize())
                        )))

                .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                        intapiDefect(coreTranslations.duplicatedObjectDetailed()))
                .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
                        intapiDefect(coreTranslations.duplicatedObjectDetailed()))

                .register(CollectionDefectIds.Size.SIZE_CANNOT_BE_MORE_THAN_MAX,
                        paramIntapiDefect(di -> coreTranslations.maxCollectionSizeDetailed(
                                di.getPath(),
                                new Identity(di.getDefect().params().getMaxSize())
                        )))
                .register(CollectionDefectIds.Size.SIZE_CANNOT_BE_LESS_THAN_MIN,
                        paramIntapiDefect(di -> coreTranslations.minCollectionSizeDetailed(
                                di.getPath(),
                                new Identity(di.getDefect().params().getMinSize())
                        )))
                .register(CollectionDefectIds.Gen.CANNOT_BE_EMPTY,
                        paramIntapiDefect(di -> coreTranslations.emptyDetailed(di.getPath())))
                .register(CollectionDefectIds.Gen.MUST_BE_EMPTY,
                        paramIntapiDefect(di -> coreTranslations.notEmptyDetailed(di.getPath())))
                .register(CollectionDefectIds.Gen.MUST_NOT_BE_IN_COLLECTION, defaultIntapiDefect())
                .register(CollectionDefectIds.Gen.CANNOT_CONTAIN_NULLS, defaultIntapiDefect())

                .register(AdDefectIds.AdIds.REQUIRED_IMPRESSION_RATE_DUE_TO_ADS_HAS_CLOSE_COUNTER,
                        defaultIntapiDefect())

                //currency amount
                .register(CurrencyDefectIds.Amount.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX, defaultIntapiDefect())
                .register(CurrencyDefectIds.Amount.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN, defaultIntapiDefect())
                .register(CurrencyDefectIds.Availability.UNAVAILABLE_CURRENCY, defaultIntapiDefect())

                //performance_filters
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.INCONSISTENT_CAMPAIGN_STRATEGY,
                        defaultIntapiDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.FILTER_CONDITIONS_IS_TOO_LONG,
                        defaultIntapiDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.MUST_CONTAIN_ANY_MORE_CONDITIONS,
                        defaultIntapiDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.INVALID_OPERATOR, defaultIntapiDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_OPERATOR, defaultIntapiDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_FIELD, defaultIntapiDefect())
                .register(PerformanceFilterDefects.PerformanceFilterNumberDefectIds.FILTER_COUNT_IS_TOO_LARGE,
                        defaultIntapiDefect())


                //promoextensions
                .register(PromoExtensionNumericDefectIds.MAX_COUNT_OF_PROMO_EXTENSIONS_CREATED, defaultIntapiDefect())

                //video segment goals
                .register(UsersSegmentDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED, defaultIntapiDefect())
                .register(UsersSegmentDefectIds.Gen.GOAL_TYPE_NOT_SUPPORTED_IN_AD_GROUP, defaultIntapiDefect())

                .register(InternalAdsAccessGroupDefects.Gen.INVALID_ROLE, defaultIntapiDefect())

                //dynamictextadtargets
                .register(DynamicTextAdTargetDefectIds.Strings.NUMBER_ARGUMENTS_MUST_BE_FROM_TO, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_URL_FORMAT, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_URL_FORMAT, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_RULE, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_NAME, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_NAME_FORMAT, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_NAME, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.AD_GROUP_NOT_FOUND, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Num.MAX_COUNT_IN_ADGROUP, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.DUPLICATE_RULES_IN_CONDITION, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Num.INVALID_FORMAT_WEBPAGE_CONDITION, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Num.NUMBER_OF_RULES_MUST_BE_FROM_TO, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.ALREADY_SUSPENDED, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.IS_NOT_SUSPENDED, defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_CAMPAIGN,
                        defaultIntapiDefect())
                .register(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_AD_GROUP,
                        defaultIntapiDefect())


                .register(MinusPhraseDefectIds.Number.NEGATIVE_KEYWORD_SETS_LIMIT_EXCEEDED,
                        paramIntapiDefect(
                                di -> MinusPhraseDefectTranslations.INSTANCE.negativeKeywordSetsLimitExceededDetailed
                                        (di.getDefect().params().getMax().intValue())))
                //balance
                .register(BalanceDefectIds.INVALID_PROMO_CODE, defaultIntapiDefect())
                .register(BalanceDefectIds.PROMOCODE_WRONG_CLIENT, defaultIntapiDefect())
                .register(BalanceDefectIds.UNIQUE_URLS_PROMOCODE, defaultIntapiDefect())
                .register(BalanceNumericDefectIds.INVALID_MINIMAL_QTY, defaultIntapiDefect())

                // organizations
                .register(OrganizationDefectIds.Gen.ORGANIZATION_NOT_FOUND,
                        intapiDefect(OrganizationDefectTranslations.INSTANCE.organizationNotFound()))
                .register(OrganizationDefectIds.Gen.INVALID_PREFER_V_CARD_OVER_PERMALINK,
                        intapiDefect(OrganizationDefectTranslations.INSTANCE.invalidPreferVCardOverPermalink()))
                .register(OrganizationDefectIds.Gen.HAS_NO_ACCESS_TO_ORGANIZATION,
                        intapiDefect(OrganizationDefectTranslations.INSTANCE.hasNoAccessToOrganization()))
                .register(OrganizationDefectIds.Gen.EITHER_PERMALINK_OR_CHAIN_CAN_BE_FILLED,
                        intapiDefect(OrganizationDefectTranslations.INSTANCE.eitherPermalinkOrChainCanBeFilled()))
                .register(OrganizationDefectIds.Statuses.INVALID_ORGANIZATION_STATUS,
                        paramIntapiDefect(di -> OrganizationDefectTranslations.INSTANCE.invalidOrganizationStatus(
                                di.getDefect().params())))

                // client phones
                .register(ClientPhoneDefects.Ids.PHONE_COUNTRY_NOT_ALLOWED, defaultIntapiDefect())

                // calltracking settings
                .register(CalltrackingSettingDefects.Ids.NO_WRITE_PERMISSIONS_ON_COUNTER, defaultIntapiDefect())
                .register(CalltrackingSettingDefects.Ids.COUNTER_NOT_AVAILABLE_FOR_CLIENT, defaultIntapiDefect())
                .register(CalltrackingSettingDefects.Ids.FORBIDDEN_DOMAIN, defaultIntapiDefect())

                //content promotion
                .register(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_EXISTING_COLLECTION,
                        paramIntapiDefect(di -> coreTranslations.notEnoughCardsinExistingCollection(
                                di.getDefect().params().getMin().intValue())))
                .register(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_NEW_COLLECTION,
                        paramIntapiDefect(di -> coreTranslations.notEnoughCardsInNewCollection(
                                di.getDefect().params().getMin().intValue())))
                .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_INACCESSIBLE,
                        intapiDefect(coreTranslations.contentInaccessibleGetmeta()))
                .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_NOT_FOUND,
                        intapiDefect(coreTranslations.contentNotFoundGetmeta()))
                .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_TYPE_IS_NOT_SUPPORTED,
                        intapiDefect(coreTranslations.contentTypeIsNotSupported()))

                // verified phones
                .register(UserPhoneDefects.PhoneDefects.EMPTY_PHONE, defaultIntapiDefect())
                .register(UserPhoneDefects.PhoneDefects.INVALID_PHONE, defaultIntapiDefect())
                .register(UserPhoneDefects.PhoneDefects.SMS_LIMIT_EXCEEDED, defaultIntapiDefect())
                .register(UserPhoneDefects.CodeDefects.INVALID_CODE, defaultIntapiDefect())
                .register(UserPhoneDefects.CodeDefects.CONFIRMATIONS_LIMIT_EXCEEDED, defaultIntapiDefect())
                .register(UserPhoneDefects.GeneralDefects.UNEXPECTED_ERROR, defaultIntapiDefect())
                .register(UserPhoneDefects.GeneralDefects.INTERNAL_PASSPORT_ERROR, defaultIntapiDefect())
                .register(UserPhoneDefects.GeneralDefects.TOO_MANY_REQUESTS, defaultIntapiDefect())
                .register(DefectIds.PHONE_MUST_BE_VERIFIED, defaultIntapiDefect())
                .register(UserPhoneDefects.PhoneIdDefects.ALREADY_BIND_AND_SECURE, defaultIntapiDefect())

                .register(DefectIds.PROMOCODE_DOMAIN_OR_CLIENT_DOES_NOT_MATCH, defaultIntapiDefect())
                .register(DefectIds.PROMOCODE_CLIENT_DOES_NOT_MATCH, defaultIntapiDefect())
                .register(DefectIds.PROMOCODE_CLIENT_DOMAIN_DOES_NOT_MATCH, defaultIntapiDefect())
                .register(DefectIds.PROMOCODE_CLIENT_HAS_MULTIPLE_DOMAINS, defaultIntapiDefect())

                // offer
                .register(OfferDefectIds.UNABLE_TO_FILTER, defaultIntapiDefect())

                // conversion source
                .register(ConversionSourceDefects.Counter.COUNTER_IS_INACCESSIBLE, defaultIntapiDefect())

                // uac
                .register(AppInfoDefectIds.Gen.APP_INFO_NOT_FOUND, defaultIntapiDefect())
                .register(TrackingUrlDefectIds.Gen.INVALID_TRACKING_URL, defaultIntapiDefect())
                .register(TrackingUrlDefectIds.Gen.INVALID_IMPRESSION_URL, defaultIntapiDefect())
                .register(TrackingUrlDefectIds.Gen.TRACKING_URL_WRONG_REDIRECT, defaultIntapiDefect())
                .register(TrackingUrlDefectIds.Gen.CANNOT_MAKE_IMPRESSION_URL, defaultIntapiDefect())
                .register(ContentDefectIds.Gen.SIZE_OF_IMAGE_CONTENTS_CANNOT_BE_MORE_THAN_MAX, defaultIntapiDefect())
                .register(ContentDefectIds.Gen.SIZE_OF_VIDEO_CONTENTS_CANNOT_BE_MORE_THAN_MAX, defaultIntapiDefect())
                .register(ContentDefectIds.Canvas.INVALIDATED_BY_CANVAS, defaultIntapiDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_APP_STORE_URL, defaultIntapiDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_APP_ID, defaultIntapiDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_GOOGLE_PLAY_URL, defaultIntapiDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_ITUNES_URL, defaultIntapiDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_URL, defaultIntapiDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.MULTIPLE_PARAMS, defaultIntapiDefect())

                // hypergeo
                .register(HyperGeoDefectIds.Gen.COUNT_OF_SEGMENTS_MUST_BE_IN_INTERVAL, defaultIntapiDefect())

                // clientmcc
                .register(ClientMccDefectIds.Gen.CLIENT_ALREADY_LINKED, defaultIntapiDefect())
                .register(ClientMccDefectIds.Gen.MCC_LINK_NOT_FOUND, defaultIntapiDefect())
                .register(ClientMccDefectIds.Gen.REQUEST_NOT_FOUND, defaultIntapiDefect())
                .register(ClientMccDefectIds.Gen.CLIENT_NOT_ALLOWED, defaultIntapiDefect())
                .register(ClientMccDefectIds.Num.MCC_REQUESTS_LIMIT_EXCEEDED, defaultIntapiDefect())
                .register(ClientMccDefectIds.Num.MANAGED_CLIENTS_LIMIT_EXCEEDED, defaultIntapiDefect())

                // generation
                .register(GenerationDefectIds.CAMPAIGN_WITHOUT_HREF, defaultIntapiDefect())
                .register(GenerationDefectIds.BAD_CAMPAIGN_HREF, defaultIntapiDefect())
                .register(GenerationDefectIds.EMPTY_SEARCH_QUERY_API_RESPONSE, defaultIntapiDefect())
                .register(GenerationDefectIds.CAMPAIGN_WITHOUT_PERMALINK, defaultIntapiDefect())
                .register(GenerationDefectIds.PERMALINK_WITHOUT_GEO, defaultIntapiDefect())
                .register(GenerationDefectIds.PERMALINK_WITHOUT_SUITABLE_GEO, defaultIntapiDefect())
                .register(GenerationDefectIds.COUNTERS_NOT_FOUND, defaultIntapiDefect())
                .register(GenerationDefectIds.DOMAIN_DISABLED, defaultIntapiDefect())
                .register(GenerationDefectIds.AD_GROUP_WITHOUT_KEYWORDS, defaultIntapiDefect())
                .register(GenerationDefectIds.IMAGE_SEARCH_API_WITHOUT_QUERY, defaultIntapiDefect())
                .register(GenerationDefectIds.EMPTY_IMAGE_SEARCH_API_RESPONSE, defaultIntapiDefect())
                .register(GenerationDefectIds.SITELINKS_NOT_FOUND, defaultIntapiDefect())
                .register(GenerationDefectIds.SITELINKS_FOUND_ONLY_FOR_COMMON_PAGE, defaultIntapiDefect())
                .register(GenerationDefectIds.SITELINKS_FOUND_FOR_PARENT_PAGE, defaultIntapiDefect())
                .register(GenerationDefectIds.RICH_CONTENT_API_USE_ZORA, defaultIntapiDefect())
                .register(GenerationDefectIds.SPRAV_API_ERROR, defaultIntapiDefect())
                .register(GenerationDefectIds.RICH_CONTENT_API_ERROR, defaultIntapiDefect())
                .register(GenerationDefectIds.SEARCH_QUERY_API_ERROR, defaultIntapiDefect())
                .register(GenerationDefectIds.IMAGE_SEARCH_API_ERROR, defaultIntapiDefect())
                .register(GenerationDefectIds.BANGEN_PROXY_API_ERROR, defaultIntapiDefect())
                .register(ExcelDefectIdsWithParams.AD_GROUP_BY_ID_NOT_FOUND, defaultIntapiDefect())
                .register(ExcelDefectIdsWithParams.AD_GROUP_ID_REQUIRED_FOR_EXISTING_AD, defaultIntapiDefect())
                .register(ExcelDefectIdsWithParams.INCONSISTENT_COLUMN_TITLES, defaultIntapiDefect())
                .register(ExcelDefectIdsWithParams.NEW_AD_GROUP_BY_NAME_NOT_FOUND, defaultIntapiDefect())
                .register(ExcelDefectIdsWithParams.NOT_ALLOWED_ADD_NEW_AD_GROUP_WITH_NEW_AD_FOR_IMPORT_MODE,
                        defaultIntapiDefect())
                .register(ExcelDefectIds.FILE_NOT_EXIST_IN_MDS, defaultIntapiDefect())
                .register(ExcelDefectIds.ADS_OR_AD_GROUPS_BELONG_TO_DIFFERENT_CAMPAIGNS, defaultIntapiDefect())
                .register(ExcelDefectIds.CRYPTA_GOAL_NOT_FOUND, defaultIntapiDefect())
                .register(ExcelDefectIds.DUPLICATE_AD_GROUP_TITLES, defaultIntapiDefect())
                .register(ExcelDefectIds.INVALID_VALUE_FOR_IMPORT, defaultIntapiDefect())
                .register(ExcelDefectIds.MORE_THAN_ONE_GOAL_TYPE_IN_ONE_RULE, defaultIntapiDefect())
                .register(ExcelDefectIds.UNSUPPORTED_AUDIENCE_RULE_TYPE, defaultIntapiDefect())
                .register(ExcelDefectIds.UNSUPPORTED_CRYPTA_RULE_TYPE, defaultIntapiDefect())
                .register(ExcelDefectIds.SOCIAL_DEMO_GOAL_NOT_FOUND, defaultIntapiDefect())
                .register(GenerationDefectIds.METRIKA_API_ERROR, defaultIntapiDefect())

                //feed offer
                .register(FeedOfferDefects.FeedOfferDefectIds.NO_OFFERS, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.UNKNOWN_OFFER_ID, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.OFFER_ID_NOT_UNIQUE, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.CLIENT_NOT_EXIST_IN_GRUT, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.INVALID_HREF, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.HREF_NOT_UNIQUE, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.NO_IMAGES, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferNumberDefectIds.OFFER_COUNT_IS_TOO_LARGE, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferNumberDefectIds.IMAGE_COUNT_IS_TOO_LARGE, defaultIntapiDefect())
                .register(FeedOfferDefects.FeedOfferNumberDefectIds.OLD_PRICE_LESS_OR_EQUAL_THAN_CURRENT,
                        defaultIntapiDefect())

                //href params
                .register(HrefParamsDefectIds.GeneralDefectIds.HREF_WITH_PARAMS_INVALID, defaultIntapiDefect())
                .register(HrefParamsDefectIds.NumberDefectIds.HREF_PARAMS_TOO_LONG, defaultIntapiDefect())

                // multipart files
                .register(DefectIds.FILE_MIME_TYPE_IS_NOT_SUPPORTED, defaultIntapiDefect())
                .register(DefectIds.NO_CONTENT_TYPE, defaultIntapiDefect())
                .build();
    }
}
