package ru.yandex.direct.intapi.validation;

import ru.yandex.direct.grid.processing.service.validation.GridDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.grid.processing.exception.GdExceptions.ACCESS_DENIED;
import static ru.yandex.direct.grid.processing.exception.GdExceptions.NO_RIGHTS;
import static ru.yandex.direct.grid.processing.exception.GdExceptions.TYCOON_SERVICE_UNAVAILABLE;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.DATES_FROM_NOT_AFTER_TO;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.INVALID_FIND_AND_REPLACE_BANNERS_HREF_PARAMS_TEXT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.INVALID_MONTH_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.INVALID_UNION;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.MUST_BE_MUTUALLY_EXCLUSIVE;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.MUST_BE_SAME_NULL_STATE;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.MUST_CONTAIN_NON_NULL_PROPS;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.OfflineReport.MAX_REPORT_PERIOD;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.OfflineReport.MIN_MONTH_FROM;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.Pixels.INVALID_AUDIENCE_PIXEL_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.Pixels.INVALID_AUDIT_PIXEL_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.TimeTarget.INVALID_TIME_BOARD_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.UNSUPPORTED_GROUP_TYPE;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class GridDefectPresentations {

    private GridDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> gridDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(MUST_BE_MUTUALLY_EXCLUSIVE, defaultIntapiDefect())
                .register(MUST_BE_SAME_NULL_STATE, defaultIntapiDefect())
                .register(DATES_FROM_NOT_AFTER_TO, defaultIntapiDefect())
                .register(MUST_CONTAIN_NON_NULL_PROPS, defaultIntapiDefect())
                .register(INVALID_FIND_AND_REPLACE_BANNERS_HREF_PARAMS_TEXT, defaultIntapiDefect())
                .register(UNSUPPORTED_GROUP_TYPE, defaultIntapiDefect())
                .register(ACCESS_DENIED, defaultIntapiDefect())
                .register(NO_RIGHTS, defaultIntapiDefect())
                .register(INVALID_MONTH_FORMAT, defaultIntapiDefect())
                .register(MIN_MONTH_FROM, defaultIntapiDefect())
                .register(MAX_REPORT_PERIOD, defaultIntapiDefect())
                .register(INVALID_AUDIENCE_PIXEL_FORMAT, defaultIntapiDefect())
                .register(INVALID_AUDIT_PIXEL_FORMAT, defaultIntapiDefect())
                .register(INVALID_UNION, defaultIntapiDefect())
                .register(INVALID_TIME_BOARD_FORMAT, defaultIntapiDefect())
                .register(TYCOON_SERVICE_UNAVAILABLE, defaultIntapiDefect())
                .register(GridDefectIds.Ids.GOAL_IDS_FROM_ORDER_BY_NOT_FOUND_IN_STAT_REQUIREMENTS,
                        defaultIntapiDefect())
                .build();
    }
}
