package ru.yandex.direct.intapi.validation;

import ru.yandex.direct.validation.result.DefectInfo;

/**
 * Интерфейс для получения сообщения об ошибке из описания дефекта
 */
@FunctionalInterface
public interface IntApiDefect {
    /**
     * @param defectInfo информация о дефекте из дерева валидации
     * @return Сообщение об ошибке
     */
    String getMessage(DefectInfo defectInfo);

    static IntApiDefect parameterizedByPath(String msg) {
        return defectInfo -> String.format(msg, defectInfo.getPath());
    }

    static IntApiDefect notParameterized(String msg) {
        return defectInfo -> msg;
    }
}
