package ru.yandex.direct.intapi.validation;

import java.math.BigInteger;

public class IntApiDefects {
    private IntApiDefects() {
    }

    public static IntApiDefect notEmptyRequest() {
        return IntApiDefect.notParameterized("Request body must be specified");
    }

    public static IntApiDefect notNull() {
        return IntApiDefect.parameterizedByPath("%s cannot be null");
    }

    public static IntApiDefect isNull() {
        return IntApiDefect.parameterizedByPath("%s must be null");
    }


    public static IntApiDefect notEmpty() {
        return IntApiDefect.parameterizedByPath("%s cannot be empty");
    }

    public static IntApiDefect isLong() {
        return IntApiDefect.parameterizedByPath("%s must be a long value");
    }

    public static IntApiDefect greaterThan(Long val) {
        return defectInfo -> String.format("%s must be greater than %s", defectInfo.getPath(), val);
    }

    public static IntApiDefect notNegativeWholeNumber() {
        return IntApiDefect.parameterizedByPath("%s must be whole non-negative number");
    }

    public static IntApiDefect notNullString() {
        return IntApiDefect.parameterizedByPath("%s can't be \"0\"");
    }

    public static IntApiDefect greaterThan(BigInteger val) {
        return defectInfo -> String.format("%s must be greater than %s", defectInfo.getPath(), val);
    }

    public static IntApiDefect greaterThanOrEqualTo(Long val) {
        return defectInfo -> String.format("%s must be greater than or equal to %s", defectInfo.getPath(), val);
    }

    public static IntApiDefect validDateTime() {
        return IntApiDefect.parameterizedByPath("%s has invalid date-time format");
    }

    public static IntApiDefect listSize(int min, int max) {
        return defectInfo -> String.format("%s must contain from %d to %d items", defectInfo.getPath(), min, max);
    }
}
