package ru.yandex.direct.intapi.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import ru.yandex.direct.intapi.validation.model.IntapiResponse;

@ParametersAreNonnullByDefault
@ControllerAdvice
public class ValidationFailStatusCodeAdvice implements ResponseBodyAdvice<IntapiResponse> {
    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.getMethod() != null &&
                IntapiResponse.class.isAssignableFrom(returnType.getMethod().getReturnType());
    }

    @Override
    public IntapiResponse beforeBodyWrite(
            IntapiResponse body, MethodParameter returnType,
            MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType,
            ServerHttpRequest request, ServerHttpResponse response
    ) {
        ErrorStatusOnValidationFail annotation =
                returnType.getMethodAnnotation(ErrorStatusOnValidationFail.class);

        if (annotation == null) {
            return body;
        }

        if (!body.isSuccessful()) {
            response.setStatusCode(annotation.status());
        }

        return body;
    }
}
