package ru.yandex.direct.intapi.validation;

import java.util.List;

import org.springframework.http.HttpStatus;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.IntApiException;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathConverter;
import ru.yandex.direct.validation.result.PathHelper;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.stream.Collectors.joining;
import static ru.yandex.direct.validation.result.PathHelper.path;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static <T> String getErrorText(ValidationResult<T, IntApiDefect> validationResult, Path rootPath) {
        return composeErrorText(validationResult.flattenErrors(), rootPath);
    }

    public static <T> String getErrorText(ValidationResult<T, IntApiDefect> validationResult) {
        return composeErrorText(validationResult.flattenErrors(), path());
    }

    private static String composeErrorText(List<DefectInfo<IntApiDefect>> flattenErrors, Path rootPath) {
        return flattenErrors.stream()
                .map(di -> di.convertPath(PathConverter.prepend(rootPath)))
                .map(e -> e.getDefect().getMessage(e))
                .collect(joining("\n"));
    }

    public static <T> void checkResult(ValidationResult<T, IntApiDefect> validationResult) {
        checkResult(validationResult, path(PathHelper.field("params")));
    }

    public static <T> void checkResult(ValidationResult<T, IntApiDefect> validationResult, Path rootPath) {
        if (validationResult.hasAnyErrors()) {
            throw new IntApiException(HttpStatus.BAD_REQUEST,
                    new ErrorResponse(ErrorResponse.ErrorCode.BAD_PARAM, getErrorText(validationResult, rootPath)));
        }
    }
}
