package ru.yandex.direct.intapi.validation.kernel;

import java.util.function.Function;

import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.validation.presentation.DefectPresentationProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

public class IntapiDefectPresentationProviders {
    private IntapiDefectPresentationProviders() {
    }

    public static <T> DefectPresentationProvider<T, TranslatableIntapiDefect> intapiDefect(
            Translatable errTranslatable) {
        return paramIntapiDefect(di -> errTranslatable);
    }

    public static <T> DefectPresentationProvider<T, TranslatableIntapiDefect> defaultIntapiDefect() {
        return paramIntapiDefect(
                di -> CommonDefectTranslations.INSTANCE.invalidValueWithOnlyPathDetailed(di.getPath()));
    }

    public static <T> DefectPresentationProvider<T, TranslatableIntapiDefect> paramIntapiDefect(
            Function<DefectInfo<? extends Defect<T>>, Translatable> translatableProviderFunction) {
        return defectInfo -> {
            Translatable errTranslatable = translatableProviderFunction.apply(defectInfo);
            return new TranslatableIntapiDefect(errTranslatable, defectInfo);
        };
    }
}
