package ru.yandex.direct.intapi.validation.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class IntapiError extends IntapiCodeTextError {
    @JsonProperty
    private String path;

    @JsonProperty
    private Object params;
    @JsonProperty
    private String description;

    public String getPath() {
        return path;
    }

    public IntapiError withPath(String path) {
        this.path = path;
        return this;
    }

    public String getCode() {

        return code;
    }

    public IntapiError withCode(String code) {
        this.code = code;
        return this;
    }

    public String getText() {
        return text;
    }

    public IntapiError withText(String text) {
        this.text = text;
        return this;
    }

    public Object getParams() {
        return params;
    }

    public IntapiError withParams(Object params) {
        this.params = params;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public IntapiError withDescription(String description) {
        this.description = description;
        return this;
    }

    public IntapiCodeTextError toCodeTextError() {
        return new IntapiCodeTextError()
                .withCode(code)
                .withText(text);
    }
}
