package ru.yandex.direct.intapi.validation.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;


@JsonInclude(JsonInclude.Include.NON_NULL)
public class IntapiValidationResponse implements IntapiResponse {
    private IntapiValidationResult intapiValidationResult;

    public IntapiValidationResponse(IntapiValidationResult intapiValidationResult) {
        this.intapiValidationResult = intapiValidationResult;
    }

    @JsonProperty("validation_result")
    public IntapiValidationResult validationResult() {
        return intapiValidationResult;
    }

    @Override
    public boolean isSuccessful() {
        return intapiValidationResult.getErrors().isEmpty();
    }

}
