package ru.yandex.direct.intapi.validation.model;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Arrays.asList;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class IntapiValidationResult {
    @JsonProperty("errors")
    private List<IntapiError> errors;

    public IntapiValidationResult() {
        this.errors = new ArrayList<>();
    }

    public IntapiValidationResult(List<IntapiError> errors) {
        this.errors = errors;
    }

    public IntapiValidationResult addErrors(List<IntapiError> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public IntapiValidationResult addErrors(IntapiError... errors) {
        this.errors.addAll(asList(errors));
        return this;
    }

    public List<IntapiError> getErrors() {
        return errors;
    }
}
