package ru.yandex.direct.intapi.webapp;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;

public class IntapiDispatcherServlet extends DispatcherServlet {

    private LocaleResolver localeResolver;

    @Override
    protected void initStrategies(ApplicationContext context) {
        super.initStrategies(context);
        initLocaleContextResolver(context);
    }

    private void initLocaleContextResolver(ApplicationContext context) {
        // required bean; this line throws NoSuchBeanDefinitionException if suitable bean is not found
        localeResolver = context.getBean(LocaleResolver.class);
    }

    @Override
    protected LocaleContext buildLocaleContext(final HttpServletRequest request) {
        return new SimpleLocaleContext(localeResolver.resolveLocale(request));
    }
}
