package ru.yandex.direct.intapi.webapp.semaphore;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Semaphore {
    int permits();

    String key();

    /**
     * timeout for lock acquire retry in milliseconds
     */
    long retryTimeout() default 0L;

    /**
     * lifetime of lock in milliseconds
     */
    long ttl() default 0L;
}
