import ru.yandex.aqua.beans.Pack
import ru.yandex.aqua.beans.PackProject
@Grapes([
        @Grab(group = "ru.yandex.aqua", module = "aqua-cli-jaxrs-client", version = "1.32")
])
import ru.yandex.aqua.client.Aqua

import java.nio.file.Path
import java.nio.file.Paths

import static javax.ws.rs.client.ClientBuilder.newClient

def apiUri = "https://aqua.yandex-team.ru/aqua-api/services/"

Path basePath = Paths.get('.').toAbsolutePath()

def export = [
        // Api5
	//'5565db10e4b069c629b24ec2': [destination: $/api5-ads/$, cut_version: true],
        //'53ad3d68e4b0be888c31c39e': [destination: $/api5-adgroups/$, cut_version: true],
	//'56d4208be4b08948c4829dfe': [destination: $/api5-adimages/$, cut_version: true],
	//'56f44220e4b09ee5925783c9': [destination: $/api5-adextensions/$, cut_version: true],
	//'58a4792fe4b05385ac6c56d2': [destination: $/api5-agencyclients/$, cut_version: true],
	//'57d932dee4b08948c4892da5': [destination: $/api5-audiencetargets/$, cut_version: true],
	//'53ee1612e4b042f0f5b5773a': [destination: $/api5-bids/$, cut_version: true],
	//'55a3a6b9e4b0cddf3e938a79': [destination: $/api5-bidmodifiers/$, cut_version: true],
	//'55ed2fcee4b05733565024ce': [destination: $/api5-campaigns/$, cut_version: true],
	//'5565fc6be4b069c629b25e0c': [destination: $/api5-changes/$, cut_version: true],
	//'56cb70eee4b09ee592479a1f': [destination: $/api5-clients/$, cut_version: true],
	//'5bad07cc8a906aec8f6584ce': [destination: $/api5-creatives/$, cut_version: true],
        //'56c830a6e4b08948c48275d5': [destination: $/api5-dictionaries/$, cut_version: true],
	//'546c93ece4b02219d5da4b80': [destination: $/api5-keywords/$, cut_version: true],
	//'58c29d1be4b05385ac782de4': [destination: $/api5-keywordsresearch/$, cut_version: true],
	//'5a30ffb76412ad01a9a0f67f': [destination: $/api5-leads/$, cut_version: true],
	//'57b477f4e4b09ee592a5f9ba': [destination: $/api5-retargetinglists/$, cut_version: true],
	//'54228c24e4b0d5d01094a050': [destination: $/api5-sandbox/$, cut_version: true],
	//'54e1e655e4b08ec3d977c27a': [destination: $/api5-sitelinks/$, cut_version: true],
	//'53ce3b67e4b00a721a9b5b05': [destination: $/api5-vcards/$, cut_version: true],

	// Web
        //'53561bf9e4b01f8802cdf06a': [destination: $/directweb-all/$, cut_version: true],

	// Java intapi
	'58526ca6e4b04506a0ac2172': [destination: $/direct-java-intapi/$, sources: ['https://github.yandex-team.ru/direct-qa/direct-java-intapi.git','https://github.yandex-team.ru/direct-qa/direct-intapi.git'], cut_version: true],
]


export.each { e -> dumpPack(new Aqua.Pack(newClient(), URI.create(apiUri)).id(e.key).getAsPackXml(), basePath, e.value)}

def dumpPack(Pack pack, Path basePath, Map<String, Object> info) {
    Path destination = basePath.resolve('packs/' + (String) info['destination'])

    destination.toFile().deleteDir()
    destination.toFile().mkdirs()

    //наименование
    destination.resolve('title').toFile().withWriter('UTF-8') {
        writer -> writer.write(pack.name)
    }

    //свойства
    pack.properties << [key: "forkCount", value: 20]
    pack.properties << [key: "direct.api.locale", value: "en"]
    pack.properties << [key: "hazelcast.disable", value: "true"]
    pack.properties << [key: "failIfNoTests", value: "false"] // Для паков с 2 и более jar, иначе при перезапуске упадет
    destination.resolve("00.properties").toFile() << pack.properties.collect { prop -> "${prop.key}=${prop.value}" }.join("\n")

    //параметры запуска (черновик)
    def runProperties = [
        "surefire.parallel.timeout":3600,
	reuseForks:false,
	"surefire.runOrder":"alphabetical",
	forkCount:20,
	"hazelcast.disable":true,
	"failIfNoTests":false, // Для паков с 2 и более jar, иначе при перезапуске упадет
    ]
    destination.resolve("98-run-settings.properties").toFile() << runProperties.collect { prop -> "${prop.key}=${prop.value}" }.join("\n")

    //артефакты
    pack.projects.each { p -> dumpProject(p, destination, (boolean) info['cut_version']) }

    // исходники
    downloadSources(info['sources'], basePath.resolve('sources/'))

}

def downloadSources(List<String> sources, Path destination) {
    destination.toFile().deleteDir()
    destination.toFile().mkdirs() 
    sources.each { source -> 
        def proc = ["git", "clone", source].execute(null, destination.toFile())
        def b = new StringBuffer()
        proc.consumeProcessErrorStream(b)
        println proc.text
        println b.toString()
    }
    ["rm", "-rf", destination.toString() + '/.git'].execute()
}

def dumpProject(PackProject project, Path destination, boolean cut_version) {
    def artifact_dir = destination.resolve("${project.maven.artifactId}")
    artifact_dir.toFile().mkdir()

    //файл с артифактом
    def artifact_file = artifact_dir.resolve('artifact').toFile()

    artifact_file << "${project.maven.groupId}:${project.maven.artifactId}"

    if (!cut_version) {
        artifact_file << ":${project.maven.version}"
    }

    //сьюты
    sutes_file = artifact_dir.resolve('00.test').toFile()
    project.suites.each { s -> sutes_file << "${s.suite.package}.${s.suite.name}${"\n"}" }

    // Аспект для аттача
    def aspect_dir = artifact_dir.resolve('src/test/resources/META-INF')
    aspect_dir.toFile().mkdirs()
    def aspect_file = aspect_dir.resolve('aop.xml').toFile()
    aspect_file << new File('aop.xml').text
}
