package ru.yandex.autotests.direct.intapi.java.data.creative;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.List;

public class ModerationInfo {
    @SerializedName("html")
    private String html;

    @SerializedName("images")
    private List<ModerationInfoImage> images;

    @SerializedName("texts")
    private List<ModerationInfoTexts> texts;

    public List<ModerationInfoTexts> getTexts() {
        return texts;
    }

    public ModerationInfo withTexts(List<ModerationInfoTexts> texts) {
        this.texts = texts;
        return this;
    }

    public List<ModerationInfoImage> getImages() {
        return images;
    }

    public ModerationInfo withImages(List<ModerationInfoImage> images) {
        this.images = images;
        return this;
    }

    public String getHtml() {
        return html;
    }

    public ModerationInfo withHtml(String html) {
        this.html = html;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }

    public static ModerationInfo fromString(String value) {
        return JsonUtils.getObject(value, ModerationInfo.class);
    }
}
