package ru.yandex.autotests.direct.intapi.java.steps;

import retrofit2.Response;

import ru.yandex.autotests.direct.intapi.BalanceclientcontrollerApi;
import ru.yandex.autotests.direct.intapi.java.core.DirectJavaIntapiBaseSteps;
import ru.yandex.autotests.direct.intapi.models.LockCampaignRequest;
import ru.yandex.qatools.allure.annotations.Step;

public class BalanceClientControllerSteps extends DirectJavaIntapiBaseSteps<BalanceclientcontrollerApi> {

    public BalanceClientControllerSteps() {
        super(BalanceclientcontrollerApi.class);
    }

    @Step("BalanceClient: управление локом на кампанию для теста")
    public Boolean redisLock(Boolean toLock, Long walletId) {
        LockCampaignRequest request = new LockCampaignRequest().withLockFlag(toLock).withWalletId(walletId);
        Object objRes = executeSafe(getApiService().redislock(request));
        return (Boolean) ((Response) objRes).body();
    }
}

