package ru.yandex.autotests.direct.intapi.java.steps;

import ru.yandex.autotests.direct.intapi.IntapiBidModifiersApi;
import ru.yandex.autotests.direct.intapi.java.core.DirectJavaIntapiBaseSteps;
import ru.yandex.autotests.direct.intapi.models.BidModifiersListWebResponse;
import ru.yandex.autotests.direct.intapi.models.ComplexBidModifierWeb;
import ru.yandex.autotests.direct.intapi.models.IntapiSuccessResponse;
import ru.yandex.autotests.direct.intapi.models.IntapiValidationResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class BidModifierControllerSteps extends DirectJavaIntapiBaseSteps<IntapiBidModifiersApi> {
    public BidModifierControllerSteps() {
        super(IntapiBidModifiersApi.class);
    }

    @Step("BidModifier: запрос validate")
    public IntapiValidationResponse validate(Long clientId, String campaignType, ComplexBidModifierWeb request) {
        return executeSafe(getApiService().intapiValidateBidModifiers(request, campaignType, clientId)).body();
    }

    @Step("BidModifier: запрос update")
    public IntapiSuccessResponse update(Long clientId, String campaignType, ComplexBidModifierWeb request, Long operatorUid, Long campaignId) {
        return executeSafe(getApiService().intapiUpdateBidModifiers(request, campaignId, campaignType, null)).body();
    }

    @Step("BidModifier: запрос get")
    public BidModifiersListWebResponse get(Long clientId, Long campaignId, Long operatorUid) {
        return executeSafe(getApiService().intapiGetBidModifiers(campaignId, null)).body();
    }
}
