#! /bin/sh

SHORT_NAME='jobs'
NAME="direct-$SHORT_NAME"
ENV=unknown
if [ -f /etc/yandex/environment.type ]; then
    ENV=$(cat /etc/yandex/environment.type)
fi

# Xmx  должен быть такой, чтобы памяти контейнера хватало на 2 приложения одновременно (выкладка релизов)
# и оставался запас на системные процессы.
case "$ENV" in
    production) MEM_OPTS="-Xmx17G";;
    testing) MEM_OPTS="-Xmx6G";;
    *) MEM_OPTS="-Xmx5G";;
esac

ulimit -v unlimited

VERSION=`cat /var/www/$NAME/version`

GC_LOG=/var/log/yandex/$NAME.gc.log
JAVA_OPTS="$MEM_OPTS \
    -Dfile.encoding=UTF-8 \
    -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true \
    -Dsun.net.inetaddr.ttl=60 -Dsun.net.inetaddr.negative.ttl=0 \
    -Djava.util.Arrays.useLegacyMergeSort=true \
    -Xlog:gc*=info,safepoint=info,age*=trace:file=$GC_LOG:time,uptime,level,tags:filecount=8,filesize=100M \
    -XX:+CrashOnOutOfMemoryError \
    -XX:+HeapDumpOnOutOfMemoryError \
    -XX:-OmitStackTraceInFastThrow \
    -XX:HeapDumpPath=/var/log/yandex/$NAME.hprof"

PROG_OPTS="--log-configs-directory /etc/direct/$SHORT_NAME/logging-config"
CLASSPATH="/var/www/$NAME/hotfix/$VERSION/classes/:/var/www/$NAME/$NAME/*:"
JAVA_ARGS=" -cp $CLASSPATH -Djava.library.path=/var/www/$NAME/$NAME ru.yandex.direct.jobs.JobsApp $PROG_OPTS"
ERROR_LOG="/var/log/yandex/$NAME.error.log"
PID_FILE="/var/run/$NAME-java.pid"

if [ -f "$ERROR_LOG" ]; then
  TODAY_ERROR_LOG=$ERROR_LOG.$(date +%Y%m%d)
  if [ -f "$TODAY_ERROR_LOG" ]; then
      cat "$ERROR_LOG" >>"$TODAY_ERROR_LOG"
      rm "$ERROR_LOG"
  else
      mv "$ERROR_LOG" "$TODAY_ERROR_LOG"
  fi
fi

echo $$ > "$PID_FILE"
exec /usr/local/yandex-direct-jdk11/bin/java ${JAVA_OPTS} ${JAVA_ARGS} $@ >"$ERROR_LOG" 2>&1
