package ru.yandex.direct.jobs;

import java.util.Properties;

import com.beust.jcommander.Parameter;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class JobSchedulerParams {
    public static final String SCHEDULER_VERSION_PARAM = "job-scheduler-version";
    private String version;

    @Parameter(
            names = {"-v", "--" + SCHEDULER_VERSION_PARAM},
            description = "Job scheduler version",
            required = true
    )
    public void setJobSchedulerVersion(String version) {
        this.version = version;
    }

    public String getJobSchedulerVersion() {
        return version;
    }

    public PropertySource asPropertySource(String name) {
        Properties props = new Properties();
        props.put(SCHEDULER_VERSION_PARAM, version);
        return new PropertiesPropertySource(name, props);
    }
}
