package ru.yandex.direct.jobs;

import com.google.common.base.Objects;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.direct.config.DirectConfigFactory;

public class MysqlDbCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        var schedulerDb = DirectConfigFactory.getCachedConfig().getString("scheduler.db");
        return Objects.equal(schedulerDb, "mysql");
    }
}

