package ru.yandex.direct.jobs.abt;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.abt.queryconf.AbPrepareQueryConf;
import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static java.util.stream.Collectors.toMap;
import static ru.yandex.direct.jobs.configuration.JobsEssentialConfiguration.AB_PREPARE_DATA_CLUSTERS;

@Component
public class AbDataPrepareParametersSource implements ParametersSource<AbDataPrepareParameter> {

    private final List<AbDataPrepareParameter> parameters;
    private static final String SEPARATOR = "---";
    private final Map<String, AbDataPrepareParameter> paramStringToAbDataPrepareParam;

    @Autowired
    public AbDataPrepareParametersSource(@Qualifier(AB_PREPARE_DATA_CLUSTERS) List<YtCluster> ytClusters,
                                         List<AbPrepareQueryConf> abPrepareQueryConfs) {
        parameters = ytClusters.stream()
                .flatMap(cluster ->
                        abPrepareQueryConfs.stream()
                                .map(conf -> new AbDataPrepareParameter(cluster, conf))
                )
                .collect(Collectors.toUnmodifiableList());

        paramStringToAbDataPrepareParam = parameters.stream()
                .collect(toMap(this::paramToString, param -> param));
    }

    @Override
    public String convertParamToString(AbDataPrepareParameter paramValue) {
        return paramToString(paramValue);
    }

    @Override
    public AbDataPrepareParameter convertStringToParam(String string) {
        if (!paramStringToAbDataPrepareParam.containsKey(string)) {
            throw new IllegalStateException("Unsupported parameter value " + string);
        }
        return paramStringToAbDataPrepareParam.get(string);
    }

    @Override
    public List<AbDataPrepareParameter> getAllParamValues() {
        return parameters;
    }

    private String paramToString(AbDataPrepareParameter abDataPrepareParameter) {
        return abDataPrepareParameter.getYtCluster().name() + SEPARATOR + abDataPrepareParameter.getQueryConfiguration().getQueryPath();
    }
}
