package ru.yandex.direct.jobs.abt;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.IntStreamEx;

@ParametersAreNonnullByDefault
public class AbUtils {
    public static String formatInstantAsDate(Instant date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(Date.from(date));
    }

    public static List<String> getPathesForNumberOfDays(Instant date,
                                                        Integer processingDayCount,
                                                        String eventsPathPrefix,
                                                        String tableName) {
        return IntStreamEx.range(0, processingDayCount)
                .boxed()
                .map(shift -> date.minusSeconds(TimeUnit.DAYS.toSeconds(shift)))
                .map(instant -> eventsPathPrefix + formatInstantAsDate(instant) + "/" + tableName)
                .toList();
    }

}
