package ru.yandex.direct.jobs.abt.check;

import java.time.Instant;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.repository.StatsDynClusterFreshnessRepository;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static java.time.temporal.ChronoUnit.DAYS;

/**
 * Проверяет, что таблица БК последний раз обновилась в день, после даты расчета, то есть все данные за день расчета
 * обновлены
 */
@Component
public class BsTablesFreshnessChecker {

    private final YtProvider ytProvider;
    private final StatsDynClusterFreshnessRepository statsDynClusterFreshnessRepository;

    public BsTablesFreshnessChecker(YtProvider ytProvider,
                                    StatsDynClusterFreshnessRepository statsDynClusterFreshnessRepository) {
        this.ytProvider = ytProvider;
        this.statsDynClusterFreshnessRepository = statsDynClusterFreshnessRepository;
    }

    public boolean check(YtCluster ytCluster, String table, Instant date) {
        var freshnessTimestamp =
                statsDynClusterFreshnessRepository.getClusterFreshnessTimeForTable(ytProvider.getOperator(ytCluster),
                        table).toEpochSecond();
        var freshnessBorder = date.plus(1, DAYS).truncatedTo(DAYS).getEpochSecond();
        return freshnessTimestamp >= freshnessBorder;
    }
}
