package ru.yandex.direct.jobs.abt.check;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.repository.YtClusterFreshnessRepository;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static java.time.temporal.ChronoUnit.DAYS;

/**
 * Проверяет, что данные синхранизатора свежие на день рассчета - данные за следующий день уже есть
 */
@Component
public class MysqlSyncTablesFreshnessChecker {
    private final YtClusterFreshnessRepository ytClusterFreshnessRepository;
    private final YtProvider ytProvider;
    private final String mysqlSyncStatePath;

    public MysqlSyncTablesFreshnessChecker(YtClusterFreshnessRepository ytClusterFreshnessRepository,
                                           YtProvider ytProvider,
                                           @Value("${abt.prepare.query.mysql_sync_state_path}") String mysqlSyncStatePath) {
        this.ytClusterFreshnessRepository = ytClusterFreshnessRepository;
        this.ytProvider = ytProvider;
        this.mysqlSyncStatePath = mysqlSyncStatePath;
    }

    public boolean check(YtCluster ytCluster, Instant date) {
        var freshnessBorder = date.plus(1, DAYS).truncatedTo(DAYS).getEpochSecond();
        List<Long> freshnessTimestamps = new ArrayList<>();
        var dynamicOperator = ytProvider.getDynamicOperator(ytCluster);
        var ppcdictFreshnessTimestamp =
                ytClusterFreshnessRepository.loadPpcdictTimestamp(dynamicOperator, mysqlSyncStatePath);
        var shardsFreshnessTimestamps =
                ytClusterFreshnessRepository.loadShardToTimestamp(dynamicOperator, mysqlSyncStatePath);
        if (Objects.isNull(ppcdictFreshnessTimestamp) || Objects.isNull(shardsFreshnessTimestamps)) {
            return false;
        }
        freshnessTimestamps.add(ppcdictFreshnessTimestamp);
        freshnessTimestamps.addAll(shardsFreshnessTimestamps.values());
        return freshnessTimestamps.stream()
                .allMatch(timestamp -> timestamp >= freshnessBorder);

    }
}
