package ru.yandex.direct.jobs.abt.check;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtTable;

/**
 * Проверяет, что таблица существует
 */
@Component
public class TableExistsChecker {

    private final YtProvider ytProvider;

    public TableExistsChecker(YtProvider ytProvider) {
        this.ytProvider = ytProvider;
    }

    public boolean check(YtCluster ytCluster, String table) {
        return ytProvider.getOperator(ytCluster).exists(new YtTable(table));
    }
}
