package ru.yandex.direct.jobs.abt.queryconf;

import java.util.List;

import ru.yandex.direct.jobs.abt.AbPreparedContext;

/**
 * Конфигурация для запросов подготовки данных  для расчета AB-метрик
 */
public interface AbPrepareQueryConf {
    /**
     * Относительный путь до файла с запросов
     */
    String getQueryPath();

    /**
     * Имя таблицы относительно общей папки с таблицами ab
     */
    String getDestTable();

    /**
     * Проверка, что данный для запроса готовы для рассчета
     * Например, используемые таблицы существуют или достаточно свежие
     */
    default boolean isReady(AbPreparedContext abPreparedContext) {
        return true;
    }

    /**
     * Дополнительные параметры запроса
     * Пул запросов, дата запроса и конечный путь таблицы - автоматические параметры
     */
    default List<Object> getQueryAdditionalParams() {
        return List.of();
    }

}
