package ru.yandex.direct.jobs.abt.queryconf;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.abt.AbPreparedContext;
import ru.yandex.direct.jobs.abt.check.MysqlSyncTablesFreshnessChecker;
import ru.yandex.direct.jobs.abt.check.TableExistsChecker;

import static java.time.temporal.ChronoUnit.DAYS;
import static ru.yandex.direct.jobs.abt.AbUtils.formatInstantAsDate;

@Component
public class BalanceQueryConf implements AbPrepareQueryConf {
    private final MysqlSyncTablesFreshnessChecker mysqlSyncTablesFreshnessChecker;
    private final TableExistsChecker tableExistsChecker;
    private final String balanceTablePrefix;
    private final String currencyTablePath;

    @Autowired
    public BalanceQueryConf(MysqlSyncTablesFreshnessChecker mysqlSyncTablesFreshnessChecker,
                            TableExistsChecker tableExistsChecker,
                            @Value("${abt.prepare.query.balance.balance_table_prefix}") String balanceTablePrefix,
                            @Value("${abt.prepare.query.currency_rates_table}") String currencyTablePath) {
        this.mysqlSyncTablesFreshnessChecker = mysqlSyncTablesFreshnessChecker;
        this.tableExistsChecker = tableExistsChecker;
        this.balanceTablePrefix = balanceTablePrefix;
        this.currencyTablePath = currencyTablePath;
    }

    @Override
    public String getQueryPath() {
        return "prepare_balance_log.sql";
    }

    @Override
    public String getDestTable() {
        return "campaign_balance_log";
    }

    @Override
    public boolean isReady(AbPreparedContext context) {
        var nextDay = formatInstantAsDate(context.getCalculateDate().plus(1, DAYS));
        var campaignBalanceTableName = "//home/direct/logs/campaign_balance/" + nextDay;
        return mysqlSyncTablesFreshnessChecker.check(context.getYtCluster(), context.getCalculateDate())
                && tableExistsChecker.check(context.getYtCluster(), campaignBalanceTableName);
    }

    @Override
    public List<Object> getQueryAdditionalParams() {
        return List.of(balanceTablePrefix, currencyTablePath);
    }

}
