package ru.yandex.direct.jobs.abt.queryconf;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.abt.AbPreparedContext;
import ru.yandex.direct.jobs.abt.check.MysqlSyncTablesFreshnessChecker;
import ru.yandex.direct.jobs.abt.check.TableExistsChecker;

import static ru.yandex.direct.jobs.abt.AbConstants.BINLOG_EVENTS_TABLE_NAME;
import static ru.yandex.direct.jobs.abt.AbUtils.formatInstantAsDate;

@Component
public class BinlogQueryConf implements AbPrepareQueryConf {

    private final MysqlSyncTablesFreshnessChecker mysqlSyncTablesFreshnessChecker;
    private final TableExistsChecker tableExistsChecker;
    private final String currencyTablePath;
    private final String binlogTablePrefix;
    private final String ppclogApiTablePrefix;
    private final String mysqlSyncPath;

    @Autowired
    public BinlogQueryConf(MysqlSyncTablesFreshnessChecker mysqlSyncTablesFreshnessChecker,
                           TableExistsChecker tableExistsChecker,
                           @Value("${abt.prepare.query.currency_rates_table}") String currencyTablePath,
                           @Value("${abt.prepare.query.binlog.binlog_table_prefix}") String binlogTablePrefix,
                           @Value("${abt.prepare.query.binlog.ppclog_api_table_prefix}") String ppclogApiTablePrefix,
                           @Value("${abt.prepare.query.mysql_sync_path}") String mysqlSyncPath) {
        this.mysqlSyncTablesFreshnessChecker = mysqlSyncTablesFreshnessChecker;
        this.tableExistsChecker = tableExistsChecker;
        this.currencyTablePath = currencyTablePath;
        this.binlogTablePrefix = binlogTablePrefix;
        this.ppclogApiTablePrefix = ppclogApiTablePrefix;
        this.mysqlSyncPath = mysqlSyncPath;
    }

    @Override
    public String getQueryPath() {
        return "prepare_binlog_events.sql";
    }

    @Override
    public String getDestTable() {
        return BINLOG_EVENTS_TABLE_NAME;
    }

    @Override
    public boolean isReady(AbPreparedContext context) {
        var binlogTableName = binlogTablePrefix + formatInstantAsDate(context.getCalculateDate());
        var ppclogApiTableName = ppclogApiTablePrefix + formatInstantAsDate(context.getCalculateDate());
        return tableExistsChecker.check(context.getYtCluster(), binlogTableName)
                && tableExistsChecker.check(context.getYtCluster(), ppclogApiTableName)
                && mysqlSyncTablesFreshnessChecker.check(context.getYtCluster(), context.getCalculateDate());
    }

    @Override
    public List<Object> getQueryAdditionalParams() {
        return List.of(currencyTablePath, binlogTablePrefix, ppclogApiTablePrefix, mysqlSyncPath);
    }

}
