package ru.yandex.direct.jobs.abt.queryconf;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.abt.AbPreparedContext;
import ru.yandex.direct.jobs.abt.check.BsTablesFreshnessChecker;
import ru.yandex.direct.jobs.abt.check.MysqlSyncTablesFreshnessChecker;

@Component
public class BsStatQueryConf implements AbPrepareQueryConf {

    private final MysqlSyncTablesFreshnessChecker mysqlSyncTablesFreshnessChecker;
    private final BsTablesFreshnessChecker bsTablesFreshnessChecker;
    private final String gridStatTable;
    private final String shardIncCidTable;
    private final String mysqlSyncPath;

    @Autowired
    public BsStatQueryConf(MysqlSyncTablesFreshnessChecker mysqlSyncTablesFreshnessChecker,
                           BsTablesFreshnessChecker bsTablesFreshnessChecker,
                           @Value("${abt.prepare.query.bsstat.grid_stat_table}") String gridStatTable,
                           @Value("${abt.prepare.query.bsstat.shard_inc_cid_table}") String shardIncCidTable,
                           @Value("${abt.prepare.query.mysql_sync_path}") String mysqlSyncPath) {
        this.mysqlSyncTablesFreshnessChecker = mysqlSyncTablesFreshnessChecker;
        this.bsTablesFreshnessChecker = bsTablesFreshnessChecker;
        this.gridStatTable = gridStatTable;
        this.shardIncCidTable = shardIncCidTable;
        this.mysqlSyncPath = mysqlSyncPath;
    }

    @Override
    public String getQueryPath() {
        return "prepare_bs_stat_log.sql";
    }

    @Override
    public String getDestTable() {
        return "bs_order_stat";
    }

    @Override
    public boolean isReady(AbPreparedContext context) {
        return bsTablesFreshnessChecker.check(context.getYtCluster(), gridStatTable,
                context.getCalculateDate())
                && mysqlSyncTablesFreshnessChecker.check(context.getYtCluster(), context.getCalculateDate());
    }

    @Override
    public List<Object> getQueryAdditionalParams() {
        return List.of(gridStatTable, shardIncCidTable, mysqlSyncPath);
    }

}
