package ru.yandex.direct.jobs.abt.queryconf;

import java.time.Instant;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.abt.AbPreparedContext;
import ru.yandex.direct.jobs.abt.check.TableExistsChecker;

import static ru.yandex.direct.jobs.abt.AbConstants.BINLOG_EVENTS_TABLE_NAME;
import static ru.yandex.direct.jobs.abt.AbUtils.getPathesForNumberOfDays;

@Component
@ParametersAreNonnullByDefault
public class IndexedBinlogQueryConf implements AbPrepareQueryConf {
    private final TableExistsChecker tableExistsChecker;

    private final Integer processingDayCount;
    private final String eventsPathPrefix;

    @Autowired
    public IndexedBinlogQueryConf(
            TableExistsChecker tableExistsChecker,
            @Value("${abt.prepare.query.indexed_binlog.binlog_events_prefix}")
                    String eventsPathPrefix,
            @Value("${abt.prepare.query.indexed_binlog.count_of_days_to_process_binlog}")
                    Integer processingDayCount
    ) {
        this.eventsPathPrefix = eventsPathPrefix;
        this.tableExistsChecker = tableExistsChecker;
        this.processingDayCount = processingDayCount;
    }

    @Override
    public String getQueryPath() {
        return "prepare_indexed_binlog_events.sql";
    }

    @Override
    public String getDestTable() {
        return "indexed_binlog_events";
    }

    @Override
    public boolean isReady(AbPreparedContext context) {
        Instant date = context.getCalculateDate();

        List<String> requiredTablePathes = getPathesForNumberOfDays(date, processingDayCount, eventsPathPrefix,
                BINLOG_EVENTS_TABLE_NAME);
        return requiredTablePathes.stream()
                .allMatch(path -> tableExistsChecker.check(context.getYtCluster(), path));
    }

    @Override
    public List<Object> getQueryAdditionalParams() {
        return List.of(eventsPathPrefix, BINLOG_EVENTS_TABLE_NAME, processingDayCount);
    }

}
