package ru.yandex.direct.jobs.abt.queryconf;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.abt.AbPreparedContext;
import ru.yandex.direct.jobs.abt.check.TableExistsChecker;

import static ru.yandex.direct.jobs.abt.AbUtils.formatInstantAsDate;

@Component
public class UaasQueryConf implements AbPrepareQueryConf {
    private final TableExistsChecker tableExistsChecker;
    private final String uaasLogPrefix;

    @Autowired
    public UaasQueryConf(TableExistsChecker tableExistsChecker,
                         @Value("${abt.prepare.query.uaas.uaas_log_prefix}") String uaasLogPrefix) {
        this.tableExistsChecker = tableExistsChecker;
        this.uaasLogPrefix = uaasLogPrefix;
    }

    @Override
    public String getQueryPath() {
        return "prepare_uaas_log.sql";
    }

    @Override
    public String getDestTable() {
        return "uaas_data";
    }

    @Override
    public boolean isReady(AbPreparedContext context) {
        var tableName = uaasLogPrefix + "/" + formatInstantAsDate(context.getCalculateDate());
        return tableExistsChecker.check(context.getYtCluster(), tableName);
    }

    @Override
    public List<Object> getQueryAdditionalParams() {
        return List.of(uaasLogPrefix);
    }

}
