package ru.yandex.direct.jobs.adfox.messaging;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.model.YtCluster;

/**
 * Описание параметров транспорта из/в Adfox.
 * <p>
 * Сейчас эти параметры ограничиваются описаниями двух очередей в YT.
 */
@SuppressWarnings("WeakerAccess")
public class AdfoxMessagingProperties {

    private final DirectConfig adfoxConfig;
    private final Queue inputQueue;
    private final Queue outputQueue;

    private AdfoxMessagingProperties(DirectConfig adfoxConfig) {
        this.adfoxConfig = adfoxConfig;
        inputQueue = new Queue("in");
        outputQueue = new Queue("out");
    }

    public static AdfoxMessagingProperties createAdfoxMessagingProperties(DirectConfig directConfig) {
        DirectConfig adfoxConfig = directConfig.getBranch("adfox");
        return new AdfoxMessagingProperties(adfoxConfig);
    }

    /**
     * Описание параметров очереди, реализованной в виде упорядоченной таблицы YT
     */
    public class Queue {
        private final DirectConfig config;

        Queue(String branch) {
            this.config = adfoxConfig.getBranch(branch);
        }

        /**
         * Кластер YT
         */
        public YtCluster cluster() {
            return YtCluster.valueOf(config.getString("cluster").toUpperCase());
        }

        /**
         * Путь до таблицы в YT
         */
        public String path() {
            return config.getString("queue_path");
        }

        @Override
        public String toString() {
            return "Queue{" +
                    cluster().name() +
                    ".[" + path() + "]" +
                    "}";
        }
    }

    /**
     * Очередь входных сообщений от Adfox
     */
    public Queue inputQueue() {
        return inputQueue;
    }

    /**
     * Очередь выходных сообщений от Adfox
     */
    public Queue outputQueue() {
        return outputQueue;
    }
}
