package ru.yandex.direct.jobs.adfox.messaging;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.adfoxmessaging.AdfoxMessagingUtils;
import ru.yandex.direct.adfoxmessaging.protos.CommonMessage;
import ru.yandex.direct.jobs.adfox.messaging.ytutils.RawQueueMessage;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Обработчик отдельного сообщения из очереди от Adfox.
 * <p>
 * В конструктор принимает маппинг {@link AdfoxMessageHandler обработчиков} на строковые идентификаторы сообщений.
 */
public class RawMessageConsumer {

    private static final Logger logger = LoggerFactory.getLogger(RawMessageConsumer.class);
    private final Map<String, AdfoxMessageHandler> messageHandlersByType;

    RawMessageConsumer(Map<String, AdfoxMessageHandler> messageHandlersByType) {
        this.messageHandlersByType = messageHandlersByType;
    }

    void consume(RawQueueMessage rawQueueMessage) throws Exception {
        String message = rawQueueMessage.getMessage();
        CommonMessage commonMessage = AdfoxMessagingUtils.parseJson(message);
        String messageType = commonMessage.getType();

        logger.info("Processing message (type: {}, timestamp: {})", messageType, commonMessage.getTimestampUtc());

        AdfoxMessageHandler adfoxMessageHandler = messageHandlersByType.get(messageType);
        checkNotNull(adfoxMessageHandler, "Can't find message handler for type %s", messageType);

        adfoxMessageHandler.handleMessage(commonMessage);
    }
}
