package ru.yandex.direct.jobs.adfox.messaging.export;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;

import ru.yandex.direct.adfoxmessaging.protos.AdfoxDealStatus;
import ru.yandex.direct.adfoxmessaging.protos.CommonMessage;
import ru.yandex.direct.adfoxmessaging.protos.DirectDealUpdatePayload;
import ru.yandex.direct.core.entity.deal.model.DealDirectSync;
import ru.yandex.direct.core.entity.deal.model.StatusDirect;

import static java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME;
import static ru.yandex.direct.adfoxmessaging.protos.AdfoxDealStatus.active;
import static ru.yandex.direct.adfoxmessaging.protos.AdfoxDealStatus.closed;
import static ru.yandex.direct.adfoxmessaging.protos.AdfoxDealStatus.created;

@ParametersAreNonnullByDefault
public class DealToUpdateMessageConverter {
    static final String DEAL_UPDATE_MESSAGE_TYPE = "deal:update";

    AdfoxDealStatus convertStatus(StatusDirect directStatus) {
        switch (directStatus) {
            case RECEIVED:
                return created;
            case ACTIVE:
                return active;
            case COMPLETED:
            case ARCHIVED:
                return closed;
            default:
                throw new IllegalStateException("Sending status " + directStatus + " is not allowed");
        }
    }

    /**
     * Переносит поля, интересные Adfox'у в {@link DirectDealUpdatePayload} и оборачивает их в {@link CommonMessage}
     */
    public CommonMessage dealToUpdateMessage(DealDirectSync deal, Instant instant) {
        DirectDealUpdatePayload dealUpdatePayload = DirectDealUpdatePayload.newBuilder()
                .setDealExportId(deal.getId())
                .setStatus(convertStatus(deal.getDirectStatus()))
                .build();
        ZonedDateTime timestampAtUtc = instant.atZone(ZoneOffset.UTC).withNano(0);
        return CommonMessage.newBuilder()
                .setType(DEAL_UPDATE_MESSAGE_TYPE)
                .setTimestampUtc(timestampAtUtc.format(ISO_OFFSET_DATE_TIME))
                .setPayload(Any.pack(dealUpdatePayload))
                .build();
    }
}
