package ru.yandex.direct.jobs.adfox.messaging.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;

import ru.yandex.direct.adfoxmessaging.protos.AdfoxDealCreatePayload;

class CreateDealMiscFieldsConverter {

    /**
     * Из переданного {@link AdfoxDealCreatePayload} извлекает параметры,
     * которые не сохраняются в отдельные колонки.
     */
    static Map<String, Object> extractMiscParameters(AdfoxDealCreatePayload adfoxDeal) {
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> adfoxSpecials = structToMap(adfoxDeal.getAdfoxSpecials());
        if (!adfoxSpecials.isEmpty()) {
            result.put("adfoxSpecials", adfoxSpecials);
        }

        return result;
    }

    private static Map<String, Object> structToMap(Struct struct) {
        Map<String, Object> result = new HashMap<>();
        Map<String, Value> fieldsMap = struct.getFieldsMap();
        fieldsMap.forEach((key, value) -> result.put(key, valueToJsonObj(value)));
        return result;
    }

    private static Object valueToJsonObj(Value value) {
        switch (value.getKindCase()) {
            case STRUCT_VALUE:
                return structToMap(value.getStructValue());
            case LIST_VALUE:
                ListValue listValue = value.getListValue();
                List<Object> result = new ArrayList<>(listValue.getValuesCount());
                for (Value listItem : listValue.getValuesList()) {
                    result.add(valueToJsonObj(listItem));
                }
                return result;
            case BOOL_VALUE:
                return value.getBoolValue();
            case NUMBER_VALUE:
                return value.getNumberValue();
            case STRING_VALUE:
                return value.getStringValue();
            case NULL_VALUE:
            case KIND_NOT_SET:
            default:
                return null;
        }
    }
}
