package ru.yandex.direct.jobs.adfox.messaging.ytutils;

/**
 * Типизированное представление строки с сообщением из упорядоченной таблицы YT.
 */
public class RawQueueMessage {
    private final long rowIndex;
    private final String message;

    public RawQueueMessage(long rowIndex, String message) {
        this.rowIndex = rowIndex;
        this.message = message;
    }

    /**
     * Значение системной колонки {@code [$row_index]}
     */
    public long getRowIndex() {
        return rowIndex;
    }

    /**
     * Сообщение
     */
    public String getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return "RawQueueMessage{" +
                "rowIndex=" + rowIndex +
                ", message='" + message + '\'' +
                '}';
    }
}
