package ru.yandex.direct.jobs.adfox.messaging.ytutils;

import java.util.List;
import java.util.function.Function;

import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedRow;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

import static ru.yandex.direct.ytwrapper.YtTableUtils.findColumnOrThrow;

/**
 * Парсер для запросов к упорядоченной таблице с сообщениями.
 *
 * @see RawQueueMessage
 */
public class RawQueueMessageRecordParser implements Function<TableSchema, Function<UnversionedRow, RawQueueMessage>> {
    private static final String MESSAGE_COLUMN_NAME = "event_json";
    private static final String ROW_INDEX_COLUMN_NAME = "$row_index";

    private static final RawQueueMessageRecordParser INSTANCE = new RawQueueMessageRecordParser();

    private RawQueueMessageRecordParser() {
    }

    public static RawQueueMessageRecordParser getInstance() {
        return INSTANCE;
    }

    @Override
    public Function<UnversionedRow, RawQueueMessage> apply(TableSchema tableSchema) {
        int messageColIdx = findColumnOrThrow(tableSchema, MESSAGE_COLUMN_NAME);
        int rowIndexIdx = findColumnOrThrow(tableSchema, ROW_INDEX_COLUMN_NAME);

        return unversionedRow -> {
            List<UnversionedValue> values = unversionedRow.getValues();
            long rowIndex = values.get(rowIndexIdx).longValue();
            String message = values.get(messageColIdx).stringValue();
            return new RawQueueMessage(rowIndex, message);
        };
    }
}
