package ru.yandex.direct.jobs.advq.offline.export;

import java.util.Arrays;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

/**
 * Описание ряда таблицы с результатом работы экспорта
 */
@ParametersAreNonnullByDefault
class OfflineAdvqExportOutputTableRow extends YtTableRow {
    static final YtField<Long> ID = new YtField<>("id", Long.class, YtField.SortOrder.ASCENDING);
    static final YtField<Long> GROUP_ID = new YtField<>("group_id", Long.class);
    static final YtField<String> ORIGINAL_KEYWORD = new YtField<>("original_keyword", String.class);
    static final YtField<String> KEYWORD = new YtField<>("keyword", String.class);
    static final YtField<String> MINUS_WORDS = new YtField<>("minus_words", String.class);
    static final YtField<String> GEO = new YtField<>("geo", String.class);
    static final YtField<String> DEVICES = new YtField<>("devices", String.class);

    OfflineAdvqExportOutputTableRow() {
        super(Arrays.asList(ID, GROUP_ID, ORIGINAL_KEYWORD, KEYWORD, MINUS_WORDS, GEO, DEVICES));
    }

    void setId(long keywordId) {
        setValue(ID, keywordId);
    }

    void setGroupId(long groupId) {
        setValue(GROUP_ID, groupId);
    }

    void setOriginalKeyword(String keyword) {
        setValue(ORIGINAL_KEYWORD, keyword);
    }

    void setKeyword(String keyword) {
        setValue(KEYWORD, keyword);
    }

    void setMinusWords(List<String> minusWords) {
        setValue(MINUS_WORDS, JsonUtils.toJson(minusWords.toArray()));
    }

    void setGeo(String geo) {
        setValue(GEO, geo);
    }

    void setDevices(List<String> devices) {
        setValue(DEVICES, JsonUtils.toJson(devices.toArray()));
    }
}
