package ru.yandex.direct.jobs.advq.offline.processing;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

/**
 * Описание ряда данных с соответствием идентификатора группы ее шарду в БД Директа
 */
@ParametersAreNonnullByDefault
class OfflineAdvqPreProcessingResultRow extends YtTableRow {
    static final YtField<Long> PID = new YtField<>("pid", Long.class);
    static final YtField<Long> SHARD = new YtField<>("shard", Long.class);

    public OfflineAdvqPreProcessingResultRow() {
        super(Arrays.asList(PID, SHARD));
    }

    Long getPid() {
        return valueOf(PID);
    }

    void setPid(Long pid) {
        setValue(PID, pid);
    }

    Long getShard() {
        return valueOf(SHARD);
    }

    void setShard(Long shard) {
        setValue(SHARD, shard);
    }
}
