package ru.yandex.direct.jobs.advq.offline.processing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

/**
 * Описание таблицы с результатом работы офлайнового ADVQ, который нужно втянуть в базу данных Директа
 */
@ParametersAreNonnullByDefault
public class OfflineAdvqProcessingBaseTableRow extends YtTableRow {
    static final String INPUT_PATH = "//home/advq/advq/direct_export/forecast_results";

    public static final YtField<Long> GROUP_ID = new YtField<>("group_id", Long.class, YtField.SortOrder.ASCENDING);
    public static final YtField<Long> ID = new YtField<>("id", Long.class, YtField.SortOrder.ASCENDING);
    public static final YtField<String> ORIGINAL_KEYWORD = new YtField<>("original_keyword", String.class);
    public static final YtField<String> GEO = new YtField<>("geo", String.class);
    public static final YtField<Long> FORECAST = new YtField<>("results", Long.class);

    public OfflineAdvqProcessingBaseTableRow() {
        this(Collections.emptyList());
    }

    public OfflineAdvqProcessingBaseTableRow(Collection<YtField> fields) {
        super(ImmutableList.<YtField>builder()
                .addAll(Arrays.asList(GROUP_ID, ID, ORIGINAL_KEYWORD, GEO, FORECAST))
                .addAll(fields)
                .build());
    }

    public Long getId() {
        return valueOf(ID);
    }

    void setId(Long id) {
        setValue(ID, id);
    }

    public Long getGroupId() {
        return valueOf(GROUP_ID);
    }

    void setGroupId(Long groupId) {
        setValue(GROUP_ID, groupId);
    }

    public String getOriginalKeyword() {
        return valueOf(ORIGINAL_KEYWORD);
    }

    void setOriginalKeyword(String originalKeyword) {
        setValue(ORIGINAL_KEYWORD, originalKeyword);
    }

    public Long getForecast() {
        return valueOf(FORECAST);
    }

    void setForecast(Long forecast) {
        setValue(FORECAST, forecast);
    }

    public String getGeo() {
        return valueOf(GEO);
    }

    void setGeo(String geo) {
        setValue(GEO, geo);
    }
}
