package ru.yandex.direct.jobs.advq.offline.processing;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.model.YtMapper;
import ru.yandex.direct.ytwrapper.model.YtTableRow;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

import static ru.yandex.direct.ytwrapper.model.YtTableRow.TABLE_INDEX_ATTR_NAME;

/**
 * Маппер, который делает две вещи:
 * 1. Проставляет номер входящей таблицы в поле TI_FIELD выходящего ряда данных
 * 2. Если у ряда данных нет поля с именем "pid", добавляет в него значение поля "group_id"
 */
@ParametersAreNonnullByDefault
public class OfflineAdvqProcessingMapper extends YtMapper {
    @Override
    public final void map(YTreeMapNode node, Yield<YTreeMapNode> yield, Statistics statistics) {
        int tableIndex = node.removeAttribute(TABLE_INDEX_ATTR_NAME).get().intValue();
        YtTableRow.TI_FIELD.insertValue(node, tableIndex);
        Long groupId = OfflineAdvqProcessingBaseTableRow.GROUP_ID.extractValue(node);
        if (groupId != null) {
            OfflineAdvqProcessingTemporaryTableRow.PID.insertValue(node, groupId);
        }

        yield.yield(0, node);
    }

    @Override
    public final void map(YtTableRow tableRow) {
        throw new UnsupportedOperationException();
    }
}
