package ru.yandex.direct.jobs.advq.offline.processing;

import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.model.YtField;

/**
 * Описание ряда таблицы с результатом работы офлайнового ADVQ, в котором идентификатор группы находится в поле "pid"
 */
@ParametersAreNonnullByDefault
class OfflineAdvqProcessingTemporaryTableRow extends OfflineAdvqProcessingBaseTableRow {
    static final YtField<Long> PID = new YtField<>("pid", Long.class);

    public OfflineAdvqProcessingTemporaryTableRow() {
        super(Collections.singleton(PID));
    }

    void setPid(Long pid) {
        setValue(PID, pid);
    }
}
