package ru.yandex.direct.jobs.agencyofflinereport;

import ru.yandex.direct.currency.CurrencyCode;

public class AgencyOfflineReportHeader {
    private final Long agencyId;//id агентства
    private final String agencyName;//название агентства
    private final CurrencyCode agencyWorkCurrency;//валюта агентства
    private final String dateFrom;//Начало периода. Дата в формате yyyy-mm-dd
    private final String dateTo;//Окончание периода. Дата в формате yyyy-mm-dd

    public AgencyOfflineReportHeader(Long agencyId, String agencyName, CurrencyCode agencyWorkCurrency,
                                     String dateFrom, String dateTo) {
        this.agencyId = agencyId;
        this.agencyName = agencyName;
        this.agencyWorkCurrency = agencyWorkCurrency;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
    }

    public Long getAgencyId() {
        return agencyId;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public CurrencyCode getAgencyWorkCurrency() {
        return agencyWorkCurrency;
    }

    public String getDateFrom() {
        return dateFrom;
    }

    public String getDateTo() {
        return dateTo;
    }
}
